﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/edid/edid_Edid.h>
#include "edid_Edid.h"

void nn::edid::detail::Initialize(Edid* pOutEdid) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutEdid);

    pOutEdid->_data = nullptr;
    pOutEdid->_size = 0;
}

bool nn::edid::detail::IsValid(const Edid* pEdid) NN_NOEXCEPT
{
    return pEdid->_data != nullptr &&
           pEdid->_size >= BlockSize &&
           pEdid->_size % BlockSize == 0;
}
