﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Macro.h>
#include <nn/edid/edid_VideoInterface.h>
#include <nn/edid/edid_SyncLevel.h>
#include <nn/edid/edid_BlankLevel.h>
#include <nn/edid/edid_SyncType.h>
#include <nn/edid/edid_ColorDepth.h>
#include "../cea861/edid_Cea861.h"

namespace nn { namespace edid {
    struct DisplayInfo;
}}

namespace nn { namespace edid { namespace detail {

    void Initialize(DisplayInfo* pOutDisplay) NN_NOEXCEPT;

    char ToAscii(std::uint8_t value) NN_NOEXCEPT;
    void GetManufacturerCode(DisplayInfo* pOutDisplay, std::uint16_t value) NN_NOEXCEPT;

    VideoInterface GetVideoInterface(std::uint8_t value) NN_NOEXCEPT;
    SyncLevel GetSignalLevel(std::uint8_t value) NN_NOEXCEPT;
    BlankLevel GetVideoSetup(std::uint8_t value) NN_NOEXCEPT;
    SyncTypeSet GetSyncTypes(std::uint8_t value) NN_NOEXCEPT;
    bool HasVsyncSerrations(std::uint8_t value) NN_NOEXCEPT;
    ColorDepth GetColorDepth(std::uint8_t value) NN_NOEXCEPT;
    ColorType GetColorSupport(VideoInterface interfaceType, std::uint8_t value) NN_NOEXCEPT;

    bool DisplayDataBlockVisitor(const std::uint8_t* pBlock, size_t size, cea861::BlockTag tag, void* pUserData) NN_NOEXCEPT;
    bool ExtensionBlockVisitor(const std::uint8_t* pBlock, size_t size, void* pUserData) NN_NOEXCEPT;

    bool IsStandbyModeSupported(std::uint8_t value) NN_NOEXCEPT;
    bool IsSuspendModeSupported(std::uint8_t value) NN_NOEXCEPT;
    bool IsVeryLowPowerSupported(std::uint8_t value) NN_NOEXCEPT;
    bool IsSrgbDefaultColorSpace(std::uint8_t value) NN_NOEXCEPT;
    bool IsContinuousFrequency(std::uint8_t value) NN_NOEXCEPT;

    struct PhysicalAddressData
    {
        std::uint16_t address;
        bool isFound;
    };

    bool PhysicalAddressVisitor(const std::uint8_t* pBlock, size_t size, void* pUserData) NN_NOEXCEPT;
    bool PhysicalAddressDataBlockVisitor(const std::uint8_t* pBlock, size_t size, cea861::BlockTag tag, void* pUserData) NN_NOEXCEPT;

}}}
