﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn { namespace edid { namespace cea861 {

    enum class BlockTag : std::uint16_t
    {
        Audio               = 0x2000,
        Video               = 0x4000,
        VendorSpecific      = 0x6000,
        SpeakerAllocation   = 0x8000,
        VesaDtc             = 0xA000,

        // Extended tags
        VideoCapability     = 0xE000,
        VendorSpecificVideo = 0xE001,
        VesaDisplayInfo     = 0xE002,
        VesaVideo           = 0xE003,
        HdmiVideo           = 0xE004,
        Colorimetry         = 0xE005,
        AudioMisc           = 0xE010,
        VendorSpecificAudio = 0xE011,
        HdmiAudio           = 0xE012,
        Undefined           = 0xFFFF,
    };

}}}
