﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/cstd/cstd_Config.h>

#if !defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_VC)
    #error  "VC++ コンパイラーが利用出来るビルド条件ではありません。"
#endif

#include <cfloat>
#include <nn/cstd/cstd_CMath.h>
#include <nn/nn_StaticAssert.h>

// VC++ では、long double は double と同じ表現です
NN_STATIC_ASSERT(sizeof(double) == sizeof(long double));

namespace nn { namespace cstd {

bool IsNan(long double value) NN_NOEXCEPT
{
    return IsNan(static_cast<double>(value));
}

bool IsNan(double value) NN_NOEXCEPT
{
    return _isnan(value) != 0;
}

bool IsNan(float value) NN_NOEXCEPT
{
    return IsNan(static_cast<double>(value));
}

bool IsInf(long double value) NN_NOEXCEPT
{
    return IsInf(static_cast<double>(value));
}

bool IsInf(double value) NN_NOEXCEPT
{
    return _isnan(value) == 0 && _finite(value) == 0;
}

bool IsInf(float value) NN_NOEXCEPT
{
    return IsInf(static_cast<double>(value));
}

}}
