﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/detail/crypto_Compare.h>

namespace nn { namespace crypto { namespace detail {

bool IsSameBytes(const void* pBuffer1, const void* pBuffer2, size_t size) NN_NOEXCEPT
{
    bool isSameSafe;

    __asm__ volatile
    (
        "mov   r3, #0\n"
        "mov   r4, #0\n"
        "b     1f\n"

        "0:\n"
        "ldrb  r5, [%[pBuffer1]]\n"
        "ldrb  r6, [%[pBuffer2]]\n"
        "adds  %[pBuffer1], %[pBuffer1], #1\n"
        "adds  %[pBuffer2], %[pBuffer2], #1\n"
        "eor   r5, r5, r6\n"
        "orr   r3, r3, r5\n"
        "adds  r4, r4, #1\n"

        "1:\n"
        "cmp   r4, %[size]\n"
        "bcc   0b\n"

        "cmp   r3, #0\n"
        "moveq %[isSameSafe], #1\n"
        "movne %[isSameSafe], #0\n"
        : [isSameSafe]"=r"(isSameSafe), [pBuffer1]"+r"(pBuffer1), [pBuffer2]"+r"(pBuffer2)
        : [size]"r"(size)
        : "r3", "r4", "r5", "r6"
    );

    return isSameSafe;
}

}}} // namespace nn::crypto::detail
