﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#include "crypto_BigNumMath.h"

namespace nn { namespace crypto { namespace detail {

/*
 * a = b+c
 * a,b,c all BigNum::Digit  arrays
 */
BigNum::Digit
nndetailCryptoBignumAddWords(BigNum::Digit* a, const BigNum::Digit* b, const BigNum::Digit* c, int digits) NN_NOEXCEPT
{
    BigNum::Digit carry = 0;

    for (int i = 0; i < digits; i++)
    {
        BigNum::Digit ai;
        if ((ai = b[i] + carry) < carry)
        {
            ai = c[i];
        }
        else if ((ai += c[i]) < c[i])
        {
            carry = 1;
        }
        else
        {
            carry = 0;
        }
        a[i] = ai;
    }
    return (carry);
}

/*
 * a = b - c all arrays, returns borrow
 */
BigNum::Digit
nndetailCryptoBignumSubWords(BigNum::Digit* a, const BigNum::Digit* b, const BigNum::Digit* c, int digits) NN_NOEXCEPT
{
    BigNum::Digit borrow = 0;

    for (int i = 0; i < digits; i++)
    {
        BigNum::Digit ai;
        if ((ai = b[i] - borrow) > (BigNum::MaxDigitValue - borrow))
        {
            ai = BigNum::MaxDigitValue - c[i];
        }
        else if ((ai -= c[i]) > (BigNum::MaxDigitValue - c[i]))
        {
            borrow = 1;
        }
        else
        {
            borrow = 0;
        }
        a[i] = ai;
    }
    return (borrow);
}

/*
 * computes a += c*d
 * return carry
 * a, d, arrays. c is digit.
 */
BigNum::Digit
nndetailCryptoBignumMulAddWords(BigNum::Digit* a, const BigNum::Digit* d, int digits, BigNum::Digit c) NN_NOEXCEPT
{
    if (c == 0)
    {
        return (0);
    }

    BigNum::Digit carry = 0;
    for (int i = 0; i < digits; i++)
    {
        BigNum::Digit t[2];
        BigNum::DigitMult(t, c, d[i]);
        if ((a[i] += carry) < carry)
        {
            carry = 1;
        }
        else
        {
            carry = 0;
        }
        if ((a[i] += t[0]) < t[0])
        {
            carry++;
        }
        carry += t[1];
    }
    return carry;
}

}}} // namespace nn::crypto::detail
