﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
/*
 * integer_math.h
 * declarations for integer math routines needed for the
 * ECDSA algorithm and RSA verification algorithms.
 *
 */

#pragma once

#include <algorithm>
#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>
#include <nn/crypto/detail/crypto_BigNum.h>

namespace nn { namespace crypto { namespace detail {

extern "C"
{
BigNum::Digit nndetailCryptoBignumAddWords(BigNum::Digit* a, const BigNum::Digit* b, const BigNum::Digit* c,
                                           int digits) NN_NOEXCEPT;
BigNum::Digit nndetailCryptoBignumSubWords(BigNum::Digit* a, const BigNum::Digit* b, const BigNum::Digit* c,
                                           int digits) NN_NOEXCEPT;
BigNum::Digit nndetailCryptoBignumMulAddWords(BigNum::Digit* a, const BigNum::Digit* b, int digits,
                                              BigNum::Digit c) NN_NOEXCEPT;
}

/* refered from BigNumMath.cpp and BigNumMath-cpu.generic.cpp
 * and it much affects performance in generic build
 */
inline void BigNum::DigitMult(Digit a[2], Digit b, Digit c) NN_NOEXCEPT
{
    DoubleDigit llres;

    llres = static_cast<DoubleDigit>(b) * static_cast<DoubleDigit>(c);
    a[0] = static_cast<Digit>(llres & 0xffffffff);
    a[1] = static_cast<Digit>(llres >> 32);
}

/* Very simple work memory management class
 * FreeDigits must be called in inverse order of AllocateDigits
 */
class BigNum::DigitAllocator
{
public:
    void Initialize(Digit* pAddress, int count) NN_NOEXCEPT
    {
        m_pAddress = pAddress;
        m_Count = count;
        m_TotalCount = count;
        m_LeastCount = count;
    }

    Digit* AllocateDigits(int count) NN_NOEXCEPT
    {
        Digit* returnAddress = nullptr;

        if (count <= m_Count)
        {
            returnAddress = m_pAddress;
            m_pAddress += count;
            m_Count -= count;

            m_LeastCount = std::min(m_LeastCount, m_Count);
        }

        return returnAddress;
    }

    void FreeDigits(void* pAddress, int count) NN_NOEXCEPT
    {
        NN_UNUSED(pAddress);

        m_pAddress -= count;
        m_Count += count;

        // Check to see if Free is called in inverse order of Alloc
        NN_SDK_ASSERT(pAddress == m_pAddress);
    }

    int GetUsedSize() const
    {
        return (m_TotalCount - m_LeastCount) * sizeof(Digit);
    }

private:
    Digit* m_pAddress;
    int    m_Count;
    int    m_TotalCount;
    int    m_LeastCount;
};

}}} // namespace nn::crypto::detail
