﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_HmacSha256Generator.h>

namespace nn { namespace crypto {

void GenerateHmacSha256Mac(void* pMac, size_t macSize,
                           const void* pData, size_t dataSize,
                           const void* pKey, size_t keySize) NN_NOEXCEPT
{
    HmacSha256Generator hmacSha256;

    hmacSha256.Initialize(pKey, keySize);
    hmacSha256.Update(pData, dataSize);
    hmacSha256.GetMac(pMac, macSize);
}

}}
