﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_Aes128CcmEncryptor.h>

namespace nn { namespace crypto {

size_t EncryptAes128Ccm(void* pDst, size_t dstSize,
                        void* pMac, size_t macBufferSize,
                        const void* pKey, size_t keySize,
                        const void* pNonce, size_t nonceSize,
                        const void* pSrc, size_t srcSize,
                        const void* pAad, size_t aadSize,
                        size_t macSize) NN_NOEXCEPT
{
    size_t processed = 0;

    Aes128CcmEncryptor aes128ccm;

    aes128ccm.Initialize(pKey, keySize, pNonce, nonceSize, aadSize, srcSize, macSize);

    if (aadSize > 0)
    {
        aes128ccm.UpdateAad(pAad, aadSize);
    }

    if (srcSize > 0)
    {
        processed = aes128ccm.Update(pDst, dstSize, pSrc, srcSize);
    }

    aes128ccm.GetMac(pMac, macBufferSize);

    return processed;
}

}}
