﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#ifndef __cplusplus

#if !defined(NN_SDK_BUILD_LIBRARY)

/**
* @file
* @brief   条件を満たしていることをテストする API の C言語用の宣言
*/

#include <nnc/nn_Common.h>
#include <nn/TargetConfigs/build_Compiler.h>
#include <nn/diag/detail/diag_DetailBuildSwitch.h>
#include <nnc/diag/detail/diag_DetailAssert.h>
#include <nnc/diag/detail/diag_DetailNamedAssert.h>

#if defined(NN_DETAIL_ENABLE_ASSERT)

#define NNC_DETAIL_ASSERT_IMPL(condition, conditionString, ...) \
    NNC_DETAIL_ASSERT_COMMON_IMPL(UserAssert, condition, conditionString, ##__VA_ARGS__)

#if !defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_AUTO_TYPE)

#define NNC_DETAIL_ASSERT_IMPL_WITHOUT_AUTO_TYPE(condition, conditionString, ...) \
    NNC_DETAIL_ASSERT_COMMON_IMPL(UserAssert, condition, conditionString)

#endif // !defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_AUTO_TYPE)

#define NNC_DETAIL_INVOKE_NAMED_ASSERT_1( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg1Stringized) \
    NNC_DETAIL_NAMED_ASSERT_IMPL_1( \
        assertImplMacroName, \
        namedAssertImplMacroName, \
        arg1, \
        arg1Stringized)

#define NNC_DETAIL_INVOKE_NAMED_ASSERT_2( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg2, \
    arg1Stringized, \
    arg2Stringized) \
    NNC_DETAIL_NAMED_ASSERT_IMPL_2( \
        assertImplMacroName, \
        namedAssertImplMacroName, \
        arg1, \
        arg2, \
        arg1Stringized, \
        arg2Stringized)

#define NNC_DETAIL_INVOKE_NAMED_ASSERT_3( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg2, \
    arg3, \
    arg1Stringized, \
    arg2Stringized, \
    arg3Stringized) \
    NNC_DETAIL_NAMED_ASSERT_IMPL_3( \
        assertImplMacroName, \
        namedAssertImplMacroName, \
        arg1, \
        arg2, \
        arg3, \
        arg1Stringized, \
        arg2Stringized, \
        arg3Stringized)

#else // #if defined(NN_DETAIL_ENABLE_ASSERT)

#define NNC_DETAIL_ASSERT_IMPL(condition, conditionString, ...) (void)(0)

#define NNC_DETAIL_INVOKE_NAMED_ASSERT_1( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg1Stringized) \
    (void)(0)

#define NNC_DETAIL_INVOKE_NAMED_ASSERT_2( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg2, \
    arg1Stringized, \
    arg2Stringized) \
    (void)(0)

#define NNC_DETAIL_INVOKE_NAMED_ASSERT_3( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg2, \
    arg3, \
    arg1Stringized, \
    arg2Stringized, \
    arg3Stringized) \
    (void)(0)

#endif // #if defined(NN_DETAIL_ENABLE_ASSERT)

/**
* @brief 条件を満たしていることをテストします。
*
* @param[in] condition    テストする条件
* @param[in] ...          条件を満たしていない場合にログとして出力するメッセージの書式指定文字列と引数
*/
#define NNC_ASSERT(condition, ...) \
    NNC_DETAIL_ASSERT_IMPL((condition), NNC_MACRO_STRINGIZE(condition), ##__VA_ARGS__);

/**
* @brief ポインタがヌルポインタではないことをテストします。
*        満たされるべき条件は pointer != nullptr です。
*/
#define NNC_ASSERT_NOT_NULL(pointer) \
    NNC_DETAIL_INVOKE_NAMED_ASSERT_1( \
        NNC_DETAIL_ASSERT_IMPL, NNC_DETAIL_ASSERT_NOT_NULL_IMPL, \
        (pointer), NNC_MACRO_STRINGIZE(pointer))

/**
* @brief 値が等しいことをテストします。
*        満たされるべき条件は lhs == rhs です。
*/
#define NNC_ASSERT_EQUAL(lhs, rhs) \
    NNC_DETAIL_INVOKE_NAMED_ASSERT_2( \
        NNC_DETAIL_ASSERT_IMPL, NNC_DETAIL_ASSERT_EQUAL_IMPL, \
        (lhs), (rhs), NNC_MACRO_STRINGIZE(lhs), NNC_MACRO_STRINGIZE(rhs))

/**
* @brief 値が等しくないことをテストします。
*        満たされるべき条件は lhs != rhs です。
*/
#define NNC_ASSERT_NOT_EQUAL(lhs, rhs) \
    NNC_DETAIL_INVOKE_NAMED_ASSERT_2( \
        NNC_DETAIL_ASSERT_IMPL, NNC_DETAIL_ASSERT_NOT_EQUAL_IMPL, \
        (lhs), (rhs), NNC_MACRO_STRINGIZE(lhs), NNC_MACRO_STRINGIZE(rhs))

/**
* @brief 値が範囲に含まれていることをテストします。
*        満たされるべき条件は (begin <= value) && (value < end) です。
*/
#define NNC_ASSERT_RANGE(value, begin, end) \
    NNC_DETAIL_INVOKE_NAMED_ASSERT_3( \
        NNC_DETAIL_ASSERT_IMPL, NNC_DETAIL_ASSERT_RANGE_IMPL, \
        (value), (begin), (end), NNC_MACRO_STRINGIZE(value), NNC_MACRO_STRINGIZE(begin), NNC_MACRO_STRINGIZE(end))

#endif // #if !defined(NN_SDK_BUILD_LIBRARY)

#endif // __cplusplus
