﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   ログ出力API関係の型定義
*/

/**
*   @brief      ログの重大性です。
*/
typedef enum {
    nndiagLogSeverity_Trace,  //!<    デバッグ時のみ関心がある情報を知らせる
    nndiagLogSeverity_Info,   //!<    想定通りのことが起きた
    nndiagLogSeverity_Warn,   //!<    想定外のことが起きた、もしくは起きそう
    nndiagLogSeverity_Error,  //!<    そのモジュールの一部の機能が実行できない
    nndiagLogSeverity_Fatal   //!<    モジュールの実行を継続できない
} nndiagLogSeverity;

/**
*   @brief      ソースコードから得られる情報です。
*/
typedef struct
{
    int lineNumber;               //!<    ソースコード内での行番号
    const char* fileName;         //!<    ソースコードのファイル名
    const char* functionName;     //!<    関数名
} nndiagSourceInfo;

/**
*   @brief      ログのメタデータです。（C 言語用）
*/
typedef struct
{
    nndiagSourceInfo sourceInfo;  //!<    ソースコードから得られる情報
    const char* moduleName;       //!<    モジュール名
    nndiagLogSeverity severity;   //!<    重大性
    int verbosity;                //!<    冗長性
    bool useDefaultLocaleCharset; //!<    ログのエンコーディングに UTF8 ではなく、ロケール既定の設定を使用している
    void* pAdditionalData;        //!<    追加のメタデータです（未使用）
    size_t additionalDataBytes;   //!<    追加のメタデータのバイト数（未使用）
} nndiagLogMetaData;
