﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   意味づけされた Assert の実装マクロです。
*/

#include <nnc/nn_Common.h>
#include <nnc/diag/detail/diag_DetailAssert.h>

#ifndef __cplusplus

#if defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_AUTO_TYPE)

#define NNC_DETAIL_NAMED_ASSERT_IMPL_1( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg1Stringized) \
    do \
    { \
        const auto& nnDetailAssertArgValue_arg1(arg1); \
        namedAssertImplMacroName( \
            assertImplMacroName, \
            nnDetailAssertArgValue_arg1, \
            arg1Stringized); \
    } while (NNC_STATIC_CONDITION(0))

#define NNC_DETAIL_NAMED_ASSERT_IMPL_2( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg2, \
    arg1Stringized, \
    arg2Stringized) \
    do \
    { \
        const auto& nnDetailAssertArgValue_arg1(arg1); \
        const auto& nnDetailAssertArgValue_arg2(arg2); \
        namedAssertImplMacroName( \
            assertImplMacroName, \
            nnDetailAssertArgValue_arg1, \
            nnDetailAssertArgValue_arg2, \
            arg1Stringized, \
            arg2Stringized); \
    } while (NNC_STATIC_CONDITION(0))

#define NNC_DETAIL_NAMED_ASSERT_IMPL_3( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg2, \
    arg3, \
    arg1Stringized, \
    arg2Stringized, \
    arg3Stringized) \
    do \
    { \
        const auto& nnDetailAssertArgValue_arg1(arg1); \
        const auto& nnDetailAssertArgValue_arg2(arg2); \
        const auto& nnDetailAssertArgValue_arg3(arg3); \
        namedAssertImplMacroName( \
            assertImplMacroName, \
            nnDetailAssertArgValue_arg1, \
            nnDetailAssertArgValue_arg2, \
            nnDetailAssertArgValue_arg3, \
            arg1Stringized, \
            arg2Stringized, \
            arg3Stringized); \
    } while (NNC_STATIC_CONDITION(0))

#else // defined(NNC_BUILD_CONFIG_COMPILER_SUPPORTS_AUTO_TYPE)

#define NNC_DETAIL_NAMED_ASSERT_IMPL_1( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg1Stringized) \
    do \
    { \
        namedAssertImplMacroName( \
            assertImplMacroName##_WITHOUT_AUTO_TYPE, \
            (arg1), \
            arg1Stringized); \
    } while (NNC_STATIC_CONDITION(0))

#define NNC_DETAIL_NAMED_ASSERT_IMPL_2( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg2, \
    arg1Stringized, \
    arg2Stringized) \
    do \
    { \
        namedAssertImplMacroName( \
            assertImplMacroName##_WITHOUT_AUTO_TYPE, \
            (arg1), \
            (arg2), \
            arg1Stringized, \
            arg2Stringized); \
    } while (NNC_STATIC_CONDITION(0))

#define NNC_DETAIL_NAMED_ASSERT_IMPL_3( \
    assertImplMacroName, \
    namedAssertImplMacroName, \
    arg1, \
    arg2, \
    arg3, \
    arg1Stringized, \
    arg2Stringized, \
    arg3Stringized) \
    do \
    { \
        namedAssertImplMacroName( \
            assertImplMacroName##_WITHOUT_AUTO_TYPE, \
            (arg1), \
            (arg2), \
            (arg3), \
            arg1Stringized, \
            arg2Stringized, \
            arg3Stringized); \
    } while (NNC_STATIC_CONDITION(0))

#endif // !defined(NNC_BUILD_CONFIG_COMPILER_SUPPORTS_AUTO_TYPE)

#define NNC_DIAG_DETAIL_NOT_NULL( lhs ) (lhs != NULL)

#define NNC_DIAG_DETAIL_EQUAL( lhs, rhs ) (lhs == rhs)

#define NNC_DIAG_DETAIL_NOT_EQUAL( lhs, rhs ) (lhs != rhs)

#define NNC_DIAG_DETAIL_WITHIN_RANGE( value, begin, end ) ((begin <= value) && (value < end))

// ヌルポインタではないことのテストです。
#define NNC_DETAIL_ASSERT_NOT_NULL_IMPL(assertImplMacroName, pointer, pointerStringized) \
    assertImplMacroName( \
        NNC_DIAG_DETAIL_NOT_NULL(pointer), \
        "NotNull", \
        "%s must not be nullptr.", \
        pointerStringized)

// 等しいことのテストです。
// 現状では、タイプセーフなフォーマットの仕組みがないため、実際の値を表示できません。
#define NNC_DETAIL_ASSERT_EQUAL_IMPL(assertImplMacroName, lhs, rhs, lhsStringized, rhsStringized) \
    assertImplMacroName( \
        NNC_DIAG_DETAIL_EQUAL(lhs, rhs), \
        "Equal", \
        "%s must be equal to %s.", \
        lhsStringized, \
        rhsStringized)

// 等しくないことのテストです。
// 現状では、タイプセーフなフォーマットの仕組みがないため、実際の値を表示できません。
#define NNC_DETAIL_ASSERT_NOT_EQUAL_IMPL(assertImplMacroName, lhs, rhs, lhsStringized, rhsStringized) \
    assertImplMacroName( \
        NNC_DIAG_DETAIL_NOT_EQUAL(lhs, rhs), \
        "NotEqual", \
        "%s must not be equal to %s.", \
        lhsStringized, \
        rhsStringized)

// 値が範囲内にあることのテストです。
// 現状では、タイプセーフなフォーマットの仕組みがないため、引数が整数であると仮定して long long にキャストしています。
#define NNC_DETAIL_ASSERT_RANGE_IMPL(assertImplMacroName, value, begin, end, valueStringized, beginStringized, endStringized) \
    assertImplMacroName( \
        NNC_DIAG_DETAIL_WITHIN_RANGE(value, begin, end), \
        "RangeCheck", \
        "%s must be within the range [%lld, %lld) (actual: %lld)", \
        valueStringized, \
        (long long)(begin), \
        (long long)(end), \
        (long long)(value))

#endif // __cplusplus
