﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   ログ出力APIの実装に利用する C 言語用関数
*/

#include <stdarg.h> // NOLINT(others/c_header)
#include <nnc/nn_Common.h>
#include <nnc/diag/diag_LogTypes.h>

#ifdef  __cplusplus
extern "C" {
#endif

// nn::diag::detail::LogImpl() を呼び出す
void nndetailDiagLogImplForC(const nndiagLogMetaData* pLogMetaData, const char* format, ...);

// nn::diag::detail::VLogImpl() を呼び出す
void nndetailDiagVLogImplForC(const nndiagLogMetaData* pLogMetaData, const char* format, va_list args);

// nn::diag::detail::PutImpl() を呼び出す
void nndetailDiagPutImplForC(const nndiagLogMetaData* pLogMetaData, const char* text, size_t length);

#ifdef  __cplusplus
} // extern "C"
#endif
