﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
* @file
* @brief   Assert APIの実装に利用する関数、マクロの定義
*/

#include <nnc/nn_Common.h>
#include <nnc/diag/diag_AssertionTypes.h>
#include <nn/TargetConfigs/build_Compiler.h>

#ifndef __cplusplus

void nndetailDiagOnAssertionFailureFormat(
    enum nndiagAssertionType assertionType,
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const char* format,
    ...);

void nndetailDiagOnAssertionFailure(
    enum nndiagAssertionType assertionType,
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber);

NNC_NORETURN void nndetailDiagAbortFormatImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber,
    const char* format,
    ...);

NNC_NORETURN void nndetailDiagAbortImpl(
    const char* condition,
    const char* functionName,
    const char* fileName,
    int lineNumber);

#define NNC_DETAIL_ASSERT_COMMON_IMPL(assertionType, condition, conditionString, ...) \
    ((void)((condition) \
    || (nndetailDiagOnAssertionFailureFormat( \
        nndiagAssertionType_##assertionType, \
        conditionString, NNC_CURRENT_FUNCTION_NAME, __FILE__, __LINE__, ##__VA_ARGS__), true)))

#define NNC_DETAIL_ABORT_UNLESS_IMPL(condition, conditionString, ...) \
    ((void)((condition) \
    || (nndetailDiagAbortFormatImpl( \
        conditionString, NNC_CURRENT_FUNCTION_NAME, __FILE__, __LINE__, ##__VA_ARGS__), true)))

#if !defined(NNC_BUILD_CONFIG_COMPILER_SUPPORTS_AUTO_TYPE)

#define NNC_DETAIL_ABORT_UNLESS_IMPL_WITHOUT_AUTO_TYPE(condition, conditionString, ...) \
    NNC_DETAIL_ABORT_UNLESS_IMPL(condition, conditionString)

#endif // __cplusplus

#endif // !defined(NN_BUILD_CONFIG_COMPILER_SUPPORTS_AUTO_TYPE)
