﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Connected speaker flags.
 */

#pragma once

#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace edid {

    /**
     * @brief Definitions for what speakers are active.
     */
    struct SpeakerAllocation
    {
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<0>  FrontPair;          //!< Front left/right speakers.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<1>  LowFrequencyEffect; //!< Subwoofer.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<2>  FrontCenter;        //!< Front center speaker.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<3>  RearPair;           //!< Rear left/right speakers.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<4>  RearCenter;         //!< Rear center speaker.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<5>  FrontCenterPair;    //!< Front left/right center speakers.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<6>  RearCenterPair;     //!< Rear left/right center speakers.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<7>  FrontWidePair;      //!< Front left/right wide speakers.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<8>  FrontHighPair;      //!< Front left/right high speakers.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<9>  TopCenter;          //!< Top center speaker.
        typedef nn::util::BitFlagSet<11, SpeakerAllocation>::Flag<10> FrontCenterHigh;    //!< Front center high speaker.
    };

    /**
     * @brief Set of speakers that may be in use by the sink device.
     */
    typedef nn::util::BitFlagSet<11, SpeakerAllocation> SpeakerAllocationSet;

}}
