﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Extended timing information for display modes.
 */

#pragma once

#include <cstdint>
#include <nn/edid/edid_SyncType.h>
#include <nn/edid/edid_Polarity.h>

namespace nn { namespace edid {

    /**
     * @brief Optional timing information for a particular display mode.
     */
    struct DisplayTimingInfo
    {
        std::uint32_t pixelClock;           //!< Pixel clock in kHz.

        std::uint16_t hactive;              //!< HACTIVE in pixels.
        std::uint16_t hblank;               //!< HBLANK in pixels.
        std::uint16_t horizontalFrontPorch; //!< Horizontal front porch in pixels.
        std::uint16_t horizontalSyncPulse;  //!< Horizontal sync pulse width in pixels.

        std::uint16_t vactive;              //!< VACTIVE in lines.
        std::uint16_t vblank;               //!< VBLANK in lines.
        std::uint16_t verticalFrontPorch;   //!< Vertical front porch in lines.
        std::uint16_t verticalSyncPulse;    //!< Vertical sync pulse width in lines.

        SyncTypeSet analogSync;             //!< Sync types supported for a particular mode.

        Polarity vsyncPolarity;             //!< Polarity for VSYNC. (Digital only.)
        Polarity hsyncPolarity;             //!< Polarity for HSYNC. (Digital only.)

        bool hasSyncSerrations;             //!< Whether HSYNC and VSYNC have serrations.
    };

}}
