﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Common audio format information.
 */

#pragma once

#include <cstdint>
#include <nn/edid/edid_AudioFormat.h>
#include <nn/edid/edid_Sampling.h>

namespace nn { namespace edid {

    /**
     * @brief Contains information about an audio format supported by the sink.
     */
    struct AudioFormatInfo
    {
        AudioFormat     format;          //!< Format code.
        int             channelCountMax; //!< Maximum number of channels supported in this format.
        SamplingRateSet samplingRates;   //!< Sampling rates supported by this format.
        std::uint8_t    _reserved;       //!< Do not use directly.
    };

}}
