﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief Public header for EDID library.
 */

#pragma once

/**
 * @namespace nn::edid
 * @brief Provides the ability to parse an EDID.
 */

#include <nn/edid/edid_Audio.h>
#include <nn/edid/edid_AudioFormat.h>
#include <nn/edid/edid_AudioFormatInfo.h>
#include <nn/edid/edid_BlankLevel.h>
#include <nn/edid/edid_ColorDepth.h>
#include <nn/edid/edid_ColorType.h>
#include <nn/edid/edid_ContentType.h>
#include <nn/edid/edid_Display.h>
#include <nn/edid/edid_DisplayInfo.h>
#include <nn/edid/edid_DisplayMode.h>
#include <nn/edid/edid_DisplayModeInfo.h>
#include <nn/edid/edid_DisplayTimingInfo.h>
#include <nn/edid/edid_Edid.h>
#include <nn/edid/edid_Error.h>
#include <nn/edid/edid_ImageSizeInfo.h>
#include <nn/edid/edid_Lib.h>
#include <nn/edid/edid_Polarity.h>
#include <nn/edid/edid_Sampling.h>
#include <nn/edid/edid_SpeakerAllocation.h>
#include <nn/edid/edid_StereoMode.h>
#include <nn/edid/edid_SyncLevel.h>
#include <nn/edid/edid_SyncType.h>
#include <nn/edid/edid_VideoInterface.h>
