﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/crypto/crypto_EcdsaP256Verifier.h>
#include <nn/crypto/crypto_Sha256Generator.h>

namespace nn { namespace crypto {

typedef EcdsaP256Verifier<nn::crypto::Sha256Generator> EcdsaP256Sha256Verifier;

inline bool VerifyEcdsaP256Sha256(const void* pSignature, size_t signatureSize,
                                  const void* publicKeyOctets, size_t publicKeySize,
                                  const void* rawMessage, size_t rawMessageSize ) NN_NOEXCEPT
{
    EcdsaP256Sha256Verifier auth;
    return auth.Verify( pSignature, signatureSize, publicKeyOctets, publicKeySize,
                        rawMessage, rawMessageSize );
}

}} // namespace nn::crypto
