﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;
using System.IO;

namespace ZarfUploader
{
    public class ServerSetting
    {
        public static ServerSetting Deserialize(string fileName)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(ServerSetting));
            using(FileStream fs = new FileStream(fileName, FileMode.Open)) {
                return serializer.Deserialize(fs) as ServerSetting;
            }
        }

        public void Serialize(string outputFileName)
        {
            XmlSerializer serializer = new XmlSerializer(typeof(ServerSetting));
            using (FileStream fs = new FileStream(outputFileName, FileMode.Create))
            {
                serializer.Serialize(fs, this);
            }
        }

        public ServerSetting() { }

        public string ServerUrl
        {
            get;
            set;
        }

        public string LoginId
        {
            get;
            set;
        }

        public string Password
        {
            get;
            set;
        }

        public string ServerUri { get; set; }
        public string IssuerUri { get; set; }
        public string ClientId { get; set; }
        public string SharedKey { get; set; }
    }
}
