﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZarfCreator.ZarfDefinitionData
{
    public class TextInfo : IEquatable<TextInfo>
    {
        /// <summary>
        /// 日本語のテキストです。
        /// </summary>
        public string Japanese { get; set; }

        /// <summary>
        /// 英語のテキストです。
        /// </summary>
        public string English { get; set; }

        /// <summary>
        /// 必要フィールドが設定されているかどうかを検証します。必須でないフィールドにはデフォルト値が入ります。
        /// </summary>
        /// <param name="errorMessage">失敗時のエラーメッセージ</param>
        /// <returns>検証結果</returns>
        internal bool Validate(out string errorMessage)
        {
            var msg = new StringBuilder();
            var result = true;

            // いずれかのテキストが必須
            if (this.Japanese == null && this.English == null)
            {
                msg.AppendLine(string.Format("Neither {0} nor {1} are specified.", Japanese, English));
                result = false;
            }

            errorMessage = msg.ToString();
            return result;
        }

        public bool Equals(TextInfo other)
        {
            if (other == null)
            {
                return false;
            }

            return
                this.Japanese == other.Japanese
                && this.English == other.English;
        }

        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }

            var textInfo = obj as TextInfo;
            if (textInfo == null)
            {
                return false;
            }
            else
            {
                return Equals(textInfo);
            }
        }


        public override int GetHashCode()
        {
            return
                (this.Japanese?.GetHashCode() ?? 0)
                ^ (this.English?.GetHashCode() ?? 0);
        }

        public Nintendo.Zarf.v1.DualText GetDualText()
        {
            var result = new Nintendo.Zarf.v1.DualText();
            if (this.Japanese != null)
            {
                result.Add(Nintendo.Zarf.v1.DualText.Japanese, this.Japanese);
            }

            if (this.English != null)
            {
                result.Add(Nintendo.Zarf.v1.DualText.English, this.English);
            }

            return result;
        }

    }
}
