﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ZarfCreator.ZarfDefinitionData
{
    public class DashboardDetailsInfo : IEquatable<DashboardDetailsInfo>
    {
        /// <summary>
        /// グループ名です。
        /// </summary>
        public string GroupName { get; set; }

        /// <summary>
        /// グループの表示名です。
        /// </summary>
        public TextInfo GroupDisplayName { get; set; }

        /// <summary>
        /// アイコンです。
        /// </summary>
        public string Icon { get; set; }

        /// <summary>
        /// テキスト表示です。
        /// </summary>
        public TextInfo DisplayText { get; set; }

        /// <summary>
        /// 必要フィールドが設定されているかどうかを検証します。必須でないフィールドにはデフォルト値が入ります。
        /// </summary>
        /// <param name="errorMessage">失敗時のエラーメッセージ</param>
        /// <returns>検証結果</returns>
        internal bool Validate(out string errorMessage)
        {
            var msg = new StringBuilder();
            var result = true;

            // GroupName は必須
            if (this.GroupName == null)
            {
                msg.AppendLine("GroupName is required.");
                result = false;
            }

            // GroupDisplayName は必須
            if (this.GroupDisplayName == null)
            {
                msg.AppendLine("GroupDisplayName is required.");
                result = false;
            }

            // DisplayText は必須
            if (this.DisplayText == null)
            {
                msg.AppendLine("DisplayText is required.");
                result = false;
            }

            errorMessage = msg.ToString();
            return result;
        }

        public bool Equals(DashboardDetailsInfo other)
        {
            if (other == null)
            {
                return false;
            }

            return
                this.GroupName == other.GroupName
                && (this.GroupDisplayName == null ? other.GroupDisplayName == null : this.GroupDisplayName.Equals(other.GroupDisplayName))
                && this.Icon == other.Icon
                && (this.DisplayText == null ? other.DisplayText == null : this.DisplayText.Equals(other.DisplayText));
        }

        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }

            var dashboardDetails = obj as DashboardDetailsInfo;
            if (dashboardDetails == null)
            {
                return false;
            }
            else
            {
                return Equals(dashboardDetails);
            }
        }

        public override int GetHashCode()
        {
            return
                (this.GroupName?.GetHashCode() ?? 0)
                ^ (this.GroupDisplayName?.GetHashCode() ?? 0)
                ^ (this.Icon?.GetHashCode() ?? 0)
                ^ (this.DisplayText?.GetHashCode() ?? 0);
        }
    }
}
