﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace ZarfCreator.VersionData
{
    public static class VersionDataFactory
    {
        public static VersionBase Create(string source, string rootDir, bool enableRelstep = false)
        {
            if (source == "")
            {
                throw new ArgumentException(string.Format("Invalid 'VersionFiles' has specified : \"{0}\"", source));
            }

            var periodIdx = source.LastIndexOf('.');
            var type = periodIdx != -1 ?
                source.Substring(periodIdx).ToLower() :
                "";

            switch(type)
            {
                case ".date":
                    return new SourceType.Date(source);
                case ".h":
                    return new SourceType.Header(source, rootDir);
                case ".txt":
                    return new SourceType.Text(source, rootDir);
                case ".xml":
                    return new SourceType.Xml(source, rootDir, enableRelstep);
                default:
                    return new SourceType.Default(source);
            }
        }
    }
}
