﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;

namespace ZarfCreator.VersionData.SourceType
{
    public class Header : VersionBase
    {
        public string rootDirectory { get; private set; }

        private static readonly Regex VersionMajor = new Regex(@"#define\s+NN_\w+_VERSION_MAJOR\s+(\d+)");
        private static readonly Regex VersionMinor = new Regex(@"#define\s+NN_\w+_VERSION_MINOR\s+(\d+)");
        private static readonly Regex VersionMicro = new Regex(@"#define\s+NN_\w+_VERSION_MICRO\s+(\d+)");

        public Header(string source, string rootDir) : base(source)
        {
            this.rootDirectory = rootDir;
        }

        public override string Read()
        {
            var versionFilePath = Path.Combine(this.rootDirectory, this.versionInfo);

            string versionFileData;
            try
            {
                using (var sr = new StreamReader(versionFilePath))
                {
                    versionFileData = sr.ReadToEnd();
                }
            }
            catch(IOException)
            {
                Console.Error.WriteLine("ERROR: Failed to open following file.\n    {0}", versionFilePath);
                throw;
            }

            var major = VersionMajor.Match(versionFileData);
            var minor = VersionMinor.Match(versionFileData);
            var micro = VersionMicro.Match(versionFileData);

            if (!(major.Success && minor.Success && micro.Success))
            {
                Console.Error.WriteLine("ERROR: Following file has invalid format.\n    {0}", versionFilePath);
                throw new ArgumentException("Invalid file has specified.");
            }

            return string.Format("{0}.{1}.{2}", major.Groups[1], minor.Groups[1], micro.Groups[1]);
        }
    }
}
