﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using ZarfCreator.ZarfDefinitionData;

namespace ZarfCreator.Parser
{
    internal class TextInfoParser
    {
        internal static TextInfo Parse(Dictionary<string, object> source)
        {
            var text = new TextInfo();

            foreach (var pair in source)
            {
                switch (pair.Key)
                {
                case TextType.Japanese:
                    text.Japanese = (string)pair.Value;
                    break;
                case TextType.English:
                    text.English = (string)pair.Value;
                    break;
                default:
                    throw new FormatException("Unknown key was specified.");
                }
            }

            string error;
            if (!text.Validate(out error))
            {
                Console.Error.WriteLine(error);

                throw new FormatException("Required items have not been completed.");
            }

            return text;
        }

        private static class TextType
        {
            public const string Japanese = "Ja";
            public const string English = "En";
        }
    }
}
