﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using Nintendo.ToolFoundation.CommandLine;
using VsSolutionBuilderNinjaExecutor;

namespace VsSolutionBuilder
{
    public class CommandLineOption
    {
        internal List<string> FilePath { get; set; }
        internal string DirectoryPath { get; set; }
        internal List<string> Target { get; set; }
            = new List<string>() { TargetTypeDefinition.BUILD };
        internal List<string> Platform { get; set; }
        internal List<string> Configuration { get; set; }
        internal List<string> Spec { get; set; }
        internal List<string> VsVersion { get; set; }
        internal List<string> ExcludeName { get; set; }
        internal bool IsCiMode { get; set; }
        internal int MaxParallelNum { get; set; } = -1;

        internal void RegiserWith(ActionCommand command)
        {
            command.AddValueOption("file",
                x => (x.Split(',')).ToList()
                    .ForEach(y => { this.FilePath = AddArgument(this.FilePath, y); }))
                .GetBuilder()
                .SetCanHaveValues()
                .SetDescription("specify target solution files");

            command.AddValueOption("path", x => this.DirectoryPath = x)
                .GetBuilder()
                .SetDescription("specify target solution directory");

            command.AddValueOption("target",
                x => (x.Split(',')).ToList()
                    .ForEach(y => { this.Target = AddArgument(this.Target, y); }))
                .GetBuilder()
                .SetCanHaveValues()
                .SetDescription("specify targets");

            command.AddValueOption("platform",
                x => (x.Split(',')).ToList()
                    .ForEach(y => { this.Platform = AddArgument(this.Platform, y); }))
                .GetBuilder()
                .SetCanHaveValues()
                .SetDescription("specify target platforms");

            command.AddValueOption("configuration",
                x => (x.Split(',')).ToList()
                    .ForEach(y => { this.Configuration = AddArgument(this.Configuration, y); }))
                .GetBuilder()
                .SetCanHaveValues()
                .SetDescription("specify target configurations");

            command.AddValueOption("spec",
                x => (x.Split(',')).ToList()
                    .ForEach(y => { this.Spec = AddArgument(this.Spec, y); }))
                .GetBuilder()
                .SetCanHaveValues(true)
                .SetDescription("specify target specs");

            command.AddValueOption("vs-version",
                x => (x.Split(',')).ToList()
                    .ForEach(y => { this.VsVersion = AddArgument(this.VsVersion, y); }))
                .GetBuilder()
                .SetCanHaveValues()
                .SetDescription("specify target vs-version default 2015,2017");

            command.AddValueOption("exclude-name",
                x => (x.Split(',')).ToList()
                    .ForEach(y => { this.ExcludeName = AddArgument(this.ExcludeName, y); }))
                .GetBuilder()
                .SetCanHaveValues()
                .SetDescription("exclude names");

            command.AddFlagOption("CIMode", () => this.IsCiMode = true)
                .GetBuilder()
                .SetDescription("if specified, run as CI mode");

            command.AddValueOption('j', "jobs", x => this.MaxParallelNum = int.Parse(x))
                .GetBuilder()
                .SetDescription("max parallel execution number");
        }

        /// <summary>
        /// 引数をリストに追加する関数
        /// </summary>
        /// <param name="strList">引数リスト</param>
        /// <param name="value">引数の値</param>
        /// <returns>追加後の引数データ</returns>
        private List<string> AddArgument(List<string> strList, string value)
        {
            if (strList == null)
            {
                strList = new List<string>();
            }
            strList.Add(value);
            return strList;
        }
    }
}
