﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    using System;

    /// <summary>
    /// テストコンテキストです。
    /// </summary>
    public sealed class TestContext
    {
        /// <summary>
        /// テスト結果ファイルの絶対パスを取得または設定します。
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// テスト名を取得または設定します。
        /// </summary>
        public string TestName { get; set; }

        /// <summary>
        /// ロールタイプを取得または設定します。
        /// </summary>
        public RoleType RoleType { get; set; }

        /// <summary>
        /// テスト ID を取得または設定します。
        /// </summary>
        public uint TestId { get; set; }

        /// <summary>
        /// グローバルリピート ID を取得または設定します。
        /// </summary>
        public uint GlobalRepeatId { get; set; }

        /// <summary>
        /// ローカルリピート ID を取得または設定します。
        /// </summary>
        public uint LocalRepeatId { get; set; }

        /// <summary>
        /// テストノードに指定されたユニットの数を取得または設定します。
        /// </summary>
        public uint UnitCount { get; set; }

        /// <summary>
        /// ユニット ID を取得または設定します。
        /// </summary>
        public uint UnitId { get; set; }

        /// <summary>
        /// 開発機の名前を取得または設定します。
        /// </summary>
        public string TargetName { get; set; }

        /// <summary>
        /// 開発機のインターフェイスを取得または設定します。
        /// </summary>
        public string TargetInterface { get; set; }

        /// <summary>
        /// 開発機のアドレスを取得または設定します。
        /// </summary>
        public string TargetAddress { get; set; }

        /// <summary>
        /// 開発機の名前の正規表現を取得または設定します。
        /// </summary>
        public string TargetNamePattern { get; set; }

        /// <summary>
        /// 開発機のインターフェイスの正規表現を取得または設定します。
        /// </summary>
        public string TargetInterfacePattern { get; set; }

        /// <summary>
        /// 結果識別コードを取得または設定します。
        /// </summary>
        public ResultCode ResultCode { get; set; }

        /// <summary>
        /// 実行するプログラムの絶対パスを取得または設定します。
        /// </summary>
        public string Command { get; set; }

        /// <summary>
        /// 実行するプログラムに渡す引数を取得または設定します。
        /// </summary>
        public string Option { get; set; }

        /// <summary>
        /// プログラム実行方式の制御パラメータを取得または設定します。
        /// </summary>
        public string Parameter { get; set; }

        /// <summary>
        /// 実行するプログラムが参照するファイルの絶対パスを取得します。
        /// </summary>
        public string[] Resources { get; set; }

        /// <summary>
        /// 実行するプログラムの失敗条件とするログ出力のパターンを取得または設定します。
        /// </summary>
        public string[] FailurePatterns { get; set; }

        /// <summary>
        /// 実行するプログラムに渡す .runsettings を取得または設定します。
        /// </summary>
        public string RunSettings { get; set; }

        /// <summary>
        /// タイムアウトまでの待ち時間（秒）を取得または設定します。
        /// </summary>
        public int Timeout { get; set; }

        /// <summary>
        /// テスト対象のプラットフォームを取得または設定します。
        /// </summary>
        public string Platform { get; set; }

        /// <summary>
        /// テスト対象のビルドタイプを取得または設定します。
        /// </summary>
        public string BuildType { get; set; }

        /// <summary>
        /// テスト対象のアプリケーションプログラムフォーマットを取得または設定します。
        /// </summary>
        public string ApplicationProgramFormat { get; set; }

        /// <summary>
        /// テスト対象のプロセスタイプを取得または設定します。
        /// </summary>
        public ProcessType ProcessType { get; set; }

        /// <summary>
        /// テスト実行にかかった時間（ミリ秒）を取得または設定します。
        /// </summary>
        public long Duration { get; set; }

        /// <summary>
        /// テスト実行の開始時刻を取得または設定します。
        /// </summary>
        public string OpeningTime { get; set; }

        /// <summary>
        /// テスト実行の終了時刻を取得または設定します。
        /// </summary>
        public string ClosingTime { get; set; }

        /// <summary>
        /// テスト実行完了時の終了コードを取得または設定します。
        /// </summary>
        public int ExitCode { get; set; }

        /// <summary>
        /// エラーメッセージを取得または設定します。
        /// </summary>
        public string ErrorMessage { get; set; }

        /// <summary>
        /// ワーキングディレクトリを取得または設定します。
        /// </summary>
        public string WorkingDirectory { get; set; }

        /// <summary>
        /// テスト結果ファイルの出力先となるディレクトリの絶対パスを取得または設定します。
        /// </summary>
        public string ResultDirectory { get; set; }

        /// <summary>
        /// テスト対象の絶対パスを取得または設定します。
        /// </summary>
        public string TargetPath { get; set; }

        /// <summary>
        /// テスト対象のプログラム ID を取得または設定します。
        /// </summary>
        public string TargetProgramId { get; set; }

        /// <summary>
        /// テスト対象のプログラム名を取得または設定します。
        /// </summary>
        public string TargetProgramName { get; set; }

        /// <summary>
        /// テスト対象のプロジェクトファイルの絶対パスを取得または設定します。
        /// </summary>
        public string TargetProjectPath { get; set; }

        /// <summary>
        /// テスト対象の実行情報ファイルの絶対パスを取得または設定します。
        /// </summary>
        public string TargetEpiPath { get; set; }

        /// <summary>
        /// ログファイルの絶対パスを取得または設定します。
        /// </summary>
        public string LogPath { get; set; }

        /// <summary>
        /// レポートファイルの絶対パスを取得または設定します。
        /// </summary>
        public string ReportPath { get; set; }

        /// <summary>
        /// 実行するプログラムに渡す .csx の絶対パスを取得または設定します。
        /// </summary>
        public string CsxPath { get; set; }

        /// <summary>
        /// 実行するプログラムに渡す .runsettings の絶対パスを取得または設定します。
        /// </summary>
        public string RunSettingsPath { get; set; }

        /// <summary>
        /// 並列実行に対応しているか否かを示す値を取得または設定します。
        /// </summary>
        public bool Parallelizable { get; set; }

        /// <summary>
        /// ブレークレベルを取得または設定します。
        /// </summary>
        public BreakLevel BreakLevel { get; set; }

        /// <summary>
        /// 後処理として実行するプログラムの絶対パスを取得または設定します。
        /// </summary>
        public string PostProcessorCommand { get; set; }

        /// <summary>
        /// 後処理として実行するプログラムに渡す引数を取得または設定します。
        /// </summary>
        public string PostProcessorOption { get; set; }

        /// <summary>
        /// 依存するテストコンテキストのテスト結果ファイルの絶対パスを取得または設定します。
        /// </summary>
        public string[] Dependencies { get; set; }

        /// <summary>
        /// 実行するプログラムのダンプファイルの形式を取得または設定します。
        /// </summary>
        public DumpFileTypeDefinition DumpFileType { get; set; }

        /// <summary>
        /// 実行するプログラムのダンプファイルの絶対パスを取得または設定します。
        /// </summary>
        public string DumpFilePath { get; set; }
    }
}
