﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    using System;

    /// <summary>
    /// ResultCode の拡張メソッドを定義します。
    /// </summary>
    public static class ResultCodeExtentions
    {
        /// <summary>
        /// スキップを意味する結果識別コードかどうかを示す値を取得します。
        /// </summary>
        /// <param name="code">結果識別コードです。</param>
        /// <returns>スキップを意味する結果識別コードかどうかを示す値です。</returns>
        public static bool MeansSkip(this ResultCode code)
        {
            switch (code)
            {
                case ResultCode.PASS:
                case ResultCode.FAIL:
                case ResultCode.TIME_OUT:
                case ResultCode.ERROR:
                    return false;
                default:
                    return true;
            }
        }

        /// <summary>
        /// CI サーバで管理できない失敗を意味する結果識別コードかどうかを示す値を取得します。
        /// </summary>
        /// <param name="code">結果識別コードです。</param>
        /// <returns>CI サーバで管理できない失敗を意味する結果識別コードかどうかを示す値です。</returns>
        public static bool MeansSerious(this ResultCode code)
        {
            switch (code)
            {
                case ResultCode.PASS:
                case ResultCode.FAIL:
                case ResultCode.SKIP:
                case ResultCode.NO_ENTRIES:
                    return false;
                default:
                    return true;
            }
        }

        /// <summary>
        /// ブレークレベル Failure に該当する結果識別コードかどうかを示す値を取得します。
        /// </summary>
        /// <param name="code">結果識別コードです。</param>
        /// <returns>ブレークレベル Failure に該当する結果識別コードかどうかを示す値です。</returns>
        public static bool MatchesBreakLevelFailure(this ResultCode code)
        {
            switch (code)
            {
                case ResultCode.PASS:
                    return false;
                default:
                    return true;
            }
        }

        /// <summary>
        /// ブレークレベル Timeout に該当する結果識別コードかどうかを示す値を取得します。
        /// </summary>
        /// <param name="code">結果識別コードです。</param>
        /// <returns>ブレークレベル Timeout に該当する結果識別コードかどうかを示す値です。</returns>
        public static bool MatchesBreakLevelTimeout(this ResultCode code)
        {
            switch (code)
            {
                case ResultCode.PASS:
                case ResultCode.FAIL:
                    return false;
                default:
                    return true;
            }
        }

        /// <summary>
        /// ブレークレベル Error に該当する結果識別コードかどうかを示す値を取得します。
        /// </summary>
        /// <param name="code">結果識別コードです。</param>
        /// <returns>ブレークレベル Error に該当する結果識別コードかどうかを示す値です。</returns>
        public static bool MatchesBreakLevelError(this ResultCode code)
        {
            switch (code)
            {
                case ResultCode.PASS:
                case ResultCode.FAIL:
                case ResultCode.TIME_OUT:
                    return false;
                default:
                    return true;
            }
        }
    }
}
