﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    using System.IO;
    using System.Text;
    using System.Xml.Serialization;

    /// <summary>
    /// オブジェクトシリアライザーを定義します。
    /// </summary>
    public static class ObjectSerializer
    {
        /// <summary>
        /// オブジェクトをシリアライズします。
        /// </summary>
        /// <param name="obj">オブジェクトインスタンスです。</param>
        /// <returns>シリアライズによって生成された文字列です。</returns>
        public static string Serialize(object obj)
        {
            using (var ms = new MemoryStream())
            using (var sw = new StreamWriter(ms, Encoding.UTF8))
            {
                var se = new XmlSerializer(obj.GetType());

                se.Serialize(sw, obj);

                sw.Flush();

                ms.Position = 0;

                using (var sr = new StreamReader(ms, Encoding.UTF8))
                {
                    return sr.ReadToEnd();
                }
            }
        }

        /// <summary>
        /// 文字列をデシリアライズします。
        /// </summary>
        /// <typeparam name="T">デシリアライズされるオブジェクトの型です。</typeparam>
        /// <param name="str">シリアライズによって生成された文字列です。</param>
        /// <returns>デシリアライズされたオブジェクトインスタンスです。</returns>
        public static T Deserialize<T>(string str)
        {
            using (var sr = new StringReader(str))
            {
                var se = new XmlSerializer(typeof(T));

                return (T)se.Deserialize(sr);
            }
        }
    }
}
