﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    using System;

    /// <summary>
    /// テストリストコンテキストが中断された場合にスローされる例外。このクラスは継承できません。
    /// </summary>
    public sealed class ListContextException : Exception
    {
        /// <summary>
        /// 指定したエラーメッセージと、当該テストリストコンテキストを利用して、ListContextException クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外の原因を説明するエラーメッセージです。</param>
        /// <param name="listContext">当該テストリストコンテキストです。</param>
        public ListContextException(string message, ListContext listContext)
            : base(message)
        {
            this.ListContext = listContext;
        }

        /// <summary>
        /// 指定したエラーメッセージ、当該テストリストコンテキスト、例外の原因である内部例外への参照を利用して、ListContextException クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">例外の原因を説明するエラーメッセージです。</param>
        /// <param name="listContext">当該テストリストコンテキストです。</param>
        /// <param name="exception">例外の原因である内部例外への参照です。</param>
        public ListContextException(string message, ListContext listContext, Exception exception)
            : base(message, exception)
        {
            this.ListContext = listContext;
        }

        /// <summary>
        /// 当該テストリストコンテキストを取得します。
        /// </summary>
        public ListContext ListContext { get; private set; }
    }
}
