﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TestRunner.Executer
{
    /// <summary>
    /// ブレークレベルです。
    /// </summary>
    public enum BreakLevel : uint
    {
        /// <summary>
        /// テスト結果が失敗となった場合にブレークします。
        /// </summary>
        Failure,

        /// <summary>
        /// 制限時間内にテスト結果を得られなかった場合にブレークします。
        /// </summary>
        Timeout,

        /// <summary>
        /// テスト実行に失敗した場合にブレークします。
        /// </summary>
        Error,

        /// <summary>
        /// ブレークしません。
        /// </summary>
        None
    }
}
