﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.Uninstall
{
    using System;
    using System.ComponentModel.Composition;
    using TargetShell.CommandPluginBase;
    using TargetShell.PluginInterface;

    /// <summary>
    /// プログラムをアンインストールするプラグイン
    /// </summary>
    [Export(typeof(ITargetShellPlugin))]
    public class Uninstall :
            BaseCommandPlugin<IDevicePluginInterface<CommandParameter>,
            CommandParameter, SubCommandArgument>
    {
        /// <summary>
        /// 必須オプションが設定されているか確認する
        /// </summary>
        /// <param name="parameter">コマンドパラメータ</param>
        /// <returns>true:設定されている false:設定されていない</returns>
        public override bool IsRequiredOption(CommandParameter parameter)
        {
            // --typeがapplicationの場合はall-uninstallがある場合と無い場合で必須オプションが変わる
            if (parameter.Type == "application")
            {
                if (!parameter.AllUninstall)
                {
                    // --all-uninstallが設定されていない場合は、--application-idが必須
                    if (string.IsNullOrWhiteSpace(parameter.ApplicationId))
                    {
                        Console.WriteLine("--application-id option is empty. Please set option.");
                        return false;
                    }
                }
            }
            // --typeがapplication以外の場合は--application-idが必須
            else
            {
                if (string.IsNullOrWhiteSpace(parameter.ApplicationId))
                {
                    Console.WriteLine("--application-id option is empty. Please set option.");
                    return false;
                }
            }
            return true;
        }
    }
}
