﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace SystemUpdaterNx.Uninstall
{
    using TargetShell.CommandPluginBase;

    /// <summary>
    /// アンインストールプラグインのコマンドパラメータ
    /// </summary>
    public class CommandParameter : BaseCommandParameter
    {
        /// <summary>
        /// インストールタイプ
        /// </summary>
        public string Type { get; set; }

        /// <summary>
        /// アンインストールアプリケーションID
        /// </summary>
        public string ApplicationId { get; set; }

        /// <summary>
        /// すべてアンインストールフラグ
        /// </summary>
        public bool AllUninstall { get; set; }

        /// <summary>
        /// パッチのインデックス
        /// </summary>
        public string Index { get; set; }
    }
}
