﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PublicNx.SettingCommon
{
    using System;
    using Properties;
    using TargetShell.CommandPluginBase;
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// 設定管理ツールの定数定義
    /// </summary>
    public class SettingCommonConstants
    {
        /// <summary>
        /// サブコマンドの文字列(Export)
        /// <summary>
        public const string ExportSubCommand = "export-setting";
        /// <summary>
        /// サブコマンドの文字列(Import)
        /// <summary>
        public const string ImportSubCommand = "import-setting";
        /// <summary>
        /// サブコマンドの文字列(Reset)
        /// <summary>
        public const string ResetSubCommand  = "reset-setting";
        /// <summary>
        /// オプション directory-path の文字列
        /// <summary>
        public const string OptionDirectoryPath = "directory-path";
        /// <summary>
        /// オプション file-path の文字列
        /// <summary>
        public const string OptionFilePath = "file-path";

        /// <summary>
        /// Edevのサーチ条件
        /// </summary>
        public const string SearchDeviceKeywordEdev = "EDEV";

        /// <summary>
        /// サポートハードウエアタイプ
        /// </summary>
        public const string SupportHardwareTypeEdev = "Edev";

        /// <summary>
        /// Sdevのサーチ条件
        /// </summary>
        public const string SearchDeviceKeywordSdev = "SDEV";

        /// <summary>
        /// サポートハードウエアタイプ
        /// </summary>
        public const string SupportHardwareTypeSdev = "Sdev";

        /// <summary>
        /// SettingsManager.exe へのパス
        /// </summary>
        public const string SettingsManager =
                @"Tools\CommandLineTools\Settings\SettingsManager.exe";

        /// <summary>
        /// デフォルトの出力フォルダ
        /// </summary>
        public const string ExportDirectory = @"TargetShellSetting";

        /// <summary>
        /// インポート元が未設定の場合に対象とするフォルダ名
        /// </summary>
        public const string ImportDirectory = "TargetShellSetting";
    }

    /// <summary>
    /// サブコマンドのオプション引数
    /// </summary>
    public class SubCommandArgument : BaseCommand<CommandParameter>, ISubCommandArgument
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SubCommandArgument(string subCommand)
        {
            this.SubCommandName = subCommand;
        }

        /// <summary>
        /// コマンドラインパーサにコマンドを登録します。
        /// </summary>
        /// <param name="commandLineParser">コマンドラインパーサです。</param>
        public void RegisterWith(CommandLineParser commandLineParser)
        {
            if (SettingCommonConstants.ExportSubCommand == this.SubCommandName)
            {
                // サブコマンド
                var exportSubcommand = commandLineParser.ActionCommand
                    .AddCommand(SettingCommonConstants.ExportSubCommand);
                exportSubcommand
                    .GetBuilder()
                    .SetDescription(SettingsResources.ExportDescription);

                // 共通オプション
                this.OptionArgs.CommonArgs.RegisterWith(exportSubcommand);

                // サブコマンド固有のオプション
                exportSubcommand
                    .AddValueOption(SettingCommonConstants.OptionDirectoryPath,
                        new Action<string>(x => this.DevicePluginArgs.DirectoryPath = x))
                    .GetBuilder()
                    .SetDescription(SettingsResources.ExportDescriptionDirectoryPath);
            }
            else if (SettingCommonConstants.ImportSubCommand == this.SubCommandName)
            {
                // サブコマンド
                var importSubcommand = commandLineParser.ActionCommand
                    .AddCommand(SettingCommonConstants.ImportSubCommand);
                importSubcommand
                    .GetBuilder()
                    .SetDescription(SettingsResources.ImportDescription);

                // 共通オプション
                this.OptionArgs.CommonArgs.RegisterWith(importSubcommand);

                // サブコマンド固有のオプション
                importSubcommand
                    .AddValueOption(SettingCommonConstants.OptionFilePath,
                        new Action<string>(x => this.DevicePluginArgs.FilePath = x))
                    .GetBuilder()
                    .SetDescription(SettingsResources.ImportDescriptionFilePath);
                importSubcommand
                    .AddValueOption(SettingCommonConstants.OptionDirectoryPath,
                        new Action<string>(x => this.DevicePluginArgs.DirectoryPath = x))
                    .GetBuilder()
                    .SetDescription(SettingsResources.ImportDescriptionDirectoryPath);
            }
            else
            {
                // サブコマンド
                var resetSubcommand = commandLineParser.ActionCommand
                    .AddCommand(SettingCommonConstants.ResetSubCommand);
                resetSubcommand
                    .GetBuilder()
                    .SetDescription(SettingsResources.ResetDescription);

                // 共通オプション
                this.OptionArgs.CommonArgs.RegisterWith(resetSubcommand);

                // サブコマンド固有のオプション
                // なし
            }
        }
    }
}
