﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace PrivateNx.InitializeBuildImage
{
    /// <summary>
    /// 初期化イメージ(initimg)を使ってSDEV初期化の定数
    /// </summary>
    public static class ConstantsSdev
    {
        /// <summary>
        /// コマンドで使用する文字列定義一覧
        /// </summary>
        public static class CommandString
        {
            /// <summary>
            /// キータイプ１の文字列
            /// </summary>
            public const string KeyTypeK1 = @"K1";
            /// <summary>
            /// キータイプ２の文字列
            /// </summary>
            public const string KeyTypeK2 = @"K2";
            /// <summary>
            /// キータイプ３の文字列
            /// </summary>
            public const string KeyTypeK3 = @"K3";
            /// <summary>
            /// キータイプ５の文字列
            /// </summary>
            public const string KeyTypeK5 = @"K5";
            /// <summary>
            /// キータイプM2の文字列
            /// </summary>
            public const string KeyTypeM2 = @"M2";
            /// <summary>
            /// NXFP2-a64プラットフォームネーム文字列
            /// </summary>
            public const string Nxfp2a64 = @"NXFP2-a64";
            /// <summary>
            /// NXFP2-a64プラットフォームネームに対応するパス名
            /// </summary>
            public const string Nxfp2a64Path = @"NX-NXFP2-a64";
            /// <summary>
            /// NXFP2-a32プラットフォームネーム文字列
            /// </summary>
            public const string Nxfp2a32 = @"NXFP2-a32";
            /// <summary>
            /// NXFP2-a32プラットフォームネームに対応するパス名
            /// </summary>
            public const string Nxfp2a32Path = @"NX-NXFP2-a32";
            /// <summary>
            /// jetson-tk2プラットフォームネーム
            /// </summary>
            public const string JetsonTk2 = @"jetson-tk2";
            /// <summary>
            /// jetson-tk2-a64プラットフォーム
            /// </summary>
            public const string JetsonTk2A64 = @"jetson-tk2-a64";
            /// <summary>
            /// 署名済みカーネルの文字列
            /// </summary>
            public const string SignedString = @"Signed";
            /// <summary>
            /// 非署名カーネルの文字列
            /// </summary>
            public const string UnsignedString = @"Unsigned";
            /// <summary>
            /// CopperDevice判定文字列
            /// </summary>
            public const string CopperDevice = @"XG";
            /// <summary>
            /// HostBridge文字列
            /// </summary>
            public const string HostBridge = "HostBridge";
            /// <summary>
            /// HostBridge文字列（ディレクトリ名に使用している）
            /// </summary>
            public const string Hb = "Hb";
            /// <summary>
            /// Usb文字列
            /// </summary>
            public const string Usb = "Usb";
            /// <summary>
            /// Publicデベロッパタイプ文字列
            /// </summary>
            public const string PublicString = @"Public";
        }

        /// <summary>
        /// UpdateHostBridgeで使用する定義一覧
        /// </summary>
        public static class UpdateHostBridge
        {
            /// <summaty>
            /// UpdateHostBridgeのプログラム名
            /// </summary>
            public const string ExeName = @"UpdateHostBridge.exe";
            /// <summaty>
            /// UpdateHostBridgeのパス
            /// </summary>
            public const string Path = @"Tools\CommandLineTools";
            /// <summary>
            /// HostBridgeのイメージパス
            /// </summary>
            public const string ImagePath =
                    @"Resources\Firmwares\NX\HostBridgeFirmware.nhf";
            /// <summary>
            /// 判定文字列検索用
            /// </summary>
            public const string SearchLineString = @"IsRecoveryUpdateRequired";
            /// <summary>
            /// ホストブリッジアップデート判定文字列
            /// </summary>
            public const string CheckString = @".IsRecoveryUpdateRequired=True";
        }
        /// <summary>
        /// RecoveryBootで使用する定義一覧
        /// </summary>
        public static class RecoveryBoot
        {
            /// <summary>
            /// RecoveryBootのプログラム名
            /// </summary>
            public const string ExeName = @"RecoveryBoot.exe";
            /// <summary>
            /// RecoveryBootのプログラムのパス
            /// </summary>
            public const string Path = @"Externals\NxSystemImages\QspiBootTools";
            /// <summary>
            /// EmmcWriteイメージのファイル名
            /// </summary>
            public const string EmmcWriterImageK1 = @"EmmcWriter.img";
            /// <summary>
            /// K2用のEmmcWriteイメージのファイル名
            /// </summary>
            public const string EmmcWriterImageK2 = @"EmmcWriter2ndKey.img";
            /// <summary>
            /// K3用のEmmcWriteイメージのファイル名
            /// </summary>
            public const string EmmcWriterImageK3 = @"EmmcWriter3rdKey.img";
            /// <summary>
            /// K5用のEmmcWriteイメージのファイル名
            /// </summary>
            public const string EmmcWriterImageK5 = @"EmmcWriter-K5.img";
            /// <summary>
            /// M2用のEmmcWriteイメージのファイル名
            /// </summary>
            public const string EmmcWriterImageM2 = @"EmmcWriter-M2.img";
            /// <summary>
            /// BootConfigファイル名
            /// Normal Sub BootConfig    params-bc-1.bin
            /// Normal Sub BootConfig    params-bc-2.bin
            /// SafeMode Main BootConfig params-bc-3.bin
            /// SafeMode Sub BootConfig  params-bc-4.bin
            /// </summary>
            public static readonly string[] ParamsBc = { @"params-bc-1.bin",
                @"params-bc-2.bin", @"params-bc-3.bin", @"params-bc-4.bin" };
            /// <summary>
            /// BootConfig生成用のバイナリのパス
            /// </summary>
            public const string ImagePath = @"Externals\NxSystemImages\QspiBootTools";
            /// <summary>
            /// ダミーブートコンフィグのファイル名
            /// </summary>
            public const string NxDummyBootConfigFile = @"bc-dummy.bin";
            /// <summary>
            /// Nxのブートコンフィグ保存パス
            /// </summary>
            public const string NxBootConfigsPath = @"Externals\NxBootConfigs";
            /// <summary>
            /// イメージファイルのアウトプットディレクトリ
            /// </summary>
            public const string OutputImagePath = @"Programs\Eris\Outputs";
            /// <summary>
            /// システムイメージのパス
            /// </summary>
            public const string SystemImagesPath = @"SystemImages\QspiBootImages";
            /// <summary>
            /// リカバリライターのファイル名
            /// </summary>
            public const string RecoveryWriterFile = @".qspi.img";
            /// <summary>
            /// リカバリライターのパス
            /// </summary>
            public const string RecoveryWirterPath = @"RecoveryWriter";
            /// <summary>
            /// ディレクトリの区切り文字列
            /// </summary>
            public const string DirectoryDelimiter = @"-";
        }
        /// <summary>
        /// GPIOControllerCUIで使用する定義一覧
        /// </summary>
        public static class GPIOControllerCUI
        {
            /// <summary>
            /// GPIOControllerCUIのファイル名
            /// </summary>
            public const string ExeName = @"GPIOControllerCUI.exe";
            /// <summary>
            /// GPIOControllerCUIのパス
            /// </summary>
            public const string Path =
                    @"Externals\HostBridge\tools\HostBridgeController\Resources\GPIOControllerCUI";
            /// <summary>
            /// HostBridgeのイメージパス
            /// </summary>
            public const string HostBridgeImage =
                    @"Resources\Firmwares\NX\HostBridgeFirmware.nhf";
        }
        /// <summary>
        /// RunOnTargetPrivateで使用する定義一覧
        /// </summary>
        public static class RunOnTargetPrivate
        {
            /// <summary>
            /// RunOnTargetPrivateのファイル名
            /// </summary>
            public const string ExeName = @"RunOnTargetPrivate.exe";
            /// <summary>
            /// RunOnTargetPrivateのパス
            /// </summary>
            public const string Path = @"Tools\CommandLineTools";
            /// <summary>
            /// SystemUpdaterHostFsのファイル名
            /// </summary>
            public const string SystemUpdaterHostFsNsp = @"SystemUpdaterHostFs.nsp";
            /// <summary>
            /// SystemUpdaterHostFsのパスの前半
            /// </summary>
            public const string SystemUpdaterHostFsNspPathBase =
                    @"Programs\Chris\Outputs";
            /// <summary>
            /// SystemUpdaterHostFsのパスの後半
            /// </summary>
            public const string SystemUpdaterHostFsNspPath =
                    @"TargetTools\SystemUpdaterHostFs";
            /// <summary>
            /// HelloWorldのファイル名
            /// </summary>
            public const string HelloWorldNsp = @"HelloWorld.nsp";
            /// <summary>
            /// イメージファイルのパスの前半
            /// </summary>
            public const string HelloWorldNspPathBase = @"Programs\Iris\Outputs";
            /// <summary>
            /// イメージファイルのパスの後半
            /// </summary>
            public const string HelloWorldNspPath = @"TargetTools\HelloWorld";
            /// <summary>
            /// イメージファイル名
            /// </summary>
            public const string InternalInitimg = @".initimg";
            /// <summary>
            /// イメージファイルのパスの前半
            /// </summary>
            public const string InternalInitimgPathBase = @"Programs\Eris\Outputs";
            /// <summary>
            /// イメージファイルのパスの後半
            /// </summary>
            public const string InternalInitimgPath = @"InitialImages";
            /// <summary>
            /// イメージファイルディレクトリの接頭文字列
            /// </summary>
            public const string DirectoryPrefix = @"NX";
            /// <summary>
            /// イメージファイルディレクトリの区切り文字列
            /// </summary>
            public const string DirectoryDelimiter = @"-";
            /// <summary>
            /// イメージサイズの文字列
            /// </summary>
            public const string LargeImageSize = @"64G";
            /// <summary>
            /// イメージサイズの文字列
            /// </summary>
            public const string SmallImageSize = @"32G";
        }
        /// <summary>
        /// ControlTargetPrivateで使用する定義一覧
        /// </summary>
        public static class ControlTargetPrivate
        {
            /// <summary>
            /// ControlTargetPrivate.exeの名前
            /// </summary>
            public const string ExeName = @"ControlTargetPrivate.exe";
            /// <summary>
            /// ControlTargetPrivate.exeのパス
            /// </summary>
            public const string Path = @"Tools\CommandLineTools";
            /// <summary>
            /// ハードウエアバージョン文字列
            /// </summary>
            public static class HardwareVersionString
            {
                /// <summary>
                /// ハードウエアバージョン検索用文字列
                /// </summary>
                public const string SearchLineString = @"###HardwareVersion";
            }
        }

        public class ConvertHardwareConfigToKeyTypeClass
        {
            public string[,] ConvertHardwareConfigToKeyTypeTable
            {
                get { return this.convertHardwareConfigToKeyTypeTable; }
            }
            /// <summary>
            /// HardwareConfigからKeyTypeに変更するコンバートテーブル
            /// </summary>
            private string[,] convertHardwareConfigToKeyTypeTable =
            {
                {
                    @"###HardwareVersion=1", "K1"
                },
                {
                    @"###HardwareVersion=2", "K1"
                },
                {
                    @"###HardwareVersion=3", "K2"
                },
                {
                    @"###HardwareVersion=4", "K1"
                },
                {
                    @"###HardwareVersion=5", "K3"
                },
                {
                    @"###HardwareVersion=6", "K3"
                },
                {
                    @"###HardwareVersion=7", "K5"
                },
                {
                    @"###HardwareVersion=9", "M2"
                },
            };
        }

        /// <summary>
        /// WriteSerialNumberToHostBridgeで使用する定義一覧
        /// </summary>
        public static class WriteSerialNumberToHostBridge
        {
            /// <summary>
            /// WriteSerialNumberToHostBridge.exeの名前
            /// </summary>
            public const string ExeName =
                    @"WriteSerialNumberToHostBridge.exe";
            /// <summary>
            /// WriteSerialNumberToHostBridge.exeのパス
            /// </summary>
            public const string Path =
                    @"Tools\CommandLineTools";
        }
        /// <summary>
        /// HostBridgeControllerで使用する定義一覧
        /// </summary>
        public static class HostBridgeController
        {
            /// <summary>
            /// HostBridgeController名
            /// </summary>
            public const string ExeName = @"Console_2_1_0.exe";
            /// <summary>
            /// HostBridgeControllerのパス
            /// </summary>
            public const string Path =
                    @"Externals\HostBridge\tools\HostBridgeController\Resources";
            /// <summary>
            /// HostBridgeControllerのパス（旧バージョン）
            /// </summary>
            public const string OldVersionsPath =
                    @"Externals\HostBridge\tools\HostBridgeController\ForOldVersions";
            /// <summary>
            /// HostBridgeのイメージパス
            /// </summary>
            public const string ImagePackage =
                    @"Externals\HostBridge\images\package.nhf";
        }
        /// <summary>
        /// HostBridgeControllerで使用する定義一覧
        /// </summary>
        public class HostBridgeControllerVersions
        {
            public string[,] List
            {
                get { return this.list; }
            }
            /// <summary>
            /// HostBridgeのバージョンと対応するHostBridgeController
            /// </summary>
            private string[,] list =
            {
                {
                    "3.11 Thu, 07 Sep 2017 17:06:34 -0700", string.Empty,
                },
            };
        }
    }
}
