﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace TargetShell.CommandPluginBase
{
    using TargetShell.Library;
    using TargetShell.PluginInterface;

    /// <summary>
    /// 共通コマンドパラメータ
    /// </summary>
    public class BaseCommand<CommandParameter> where CommandParameter : new()
    {
        /// <summary>
        /// サブコマンドの名前
        /// </summary>
        public string SubCommandName { get; set; }
        /// <summary>
        /// オプションの引数
        /// </summary>
        public OptionArgs OptionArgs { get; set; }
        /// <summary>
        /// コマンドパラメータ
        /// </summary>
        public CommandParameter DevicePluginArgs { get; set; }
        /// <summary>
        /// TargetManager継続フラグ
        /// </summary>
        public bool KeepTargetManagerFlag { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public BaseCommand()
        {
            this.OptionArgs = new OptionArgs();
            this.OptionArgs.CommonArgs = new CommonOptions();
            this.DevicePluginArgs = new CommandParameter();
            this.OptionArgs.DevicePluginArgs =
                    TargetShellLibrary.CastParameter<CommonDevicePluginOptions>(DevicePluginArgs);
        }
    }
}
