﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace SampleLogFileCompareExecute
{
    using System;
    using System.Linq;
    using Nintendo.ToolFoundation.CommandLine;
    using SampleLogFileCompare;

    internal class SampleLogFileCompareExecutor
    {
        /// <summary>
        /// 誤ったログ比較順番のオプションを指定した際に使用する文字列
        /// </summary>
        private const string LogSequenceMessage = "LogSequenceType";
        /// <summary>
        /// 誤った文字列比較のオプションを指定した際に使用する文字列
        /// </summary>
        private const string MatchPatternMessage = "MatchPattern";

        internal static void Main(string[] args)
        {
            var option = ParseArgs(args);

            var logSequenceType = (SampleLogFileComparator.LogSequence)Enum.Parse(
                typeof(SampleLogFileComparator.LogSequence), option.LogSequenceType, true);
            var matchPattern = (SampleLogFileComparator.MatchPattern)Enum.Parse(
                typeof(SampleLogFileComparator.MatchPattern), option.MatchPattern, true);
            try
            {
                var sampleLogFileComparator =
                    new SampleLogFileComparator(option.PatternFile,
                                                option.LogFile,
                                                logSequenceType,
                                                matchPattern,
                                                option.IgnoreRunOnTargetLog);
                var isMatch = sampleLogFileComparator.LogfileCompare();
                if (!isMatch)
                {
                    Environment.Exit(1);
                }
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());
                Environment.Exit(1);
            }
        }

        /// <summary>
        /// プログラム引数をチェックする。
        /// </summary>
        /// <param name="args">プログラム引数</param>
        /// <returns>オプション</returns>
        private static CommandLineOption ParseArgs(string[] args)
        {
            var options = new CommandLineOption();

            var parser = new DelegateBasedCommandLineParser();

            parser.AddHelp(Console.WriteLine);

            options.RegiserWith(parser);

            if (!parser.ParseArgs(args, Console.WriteLine))
            {
                Environment.Exit(1);
            }

            CheckOptionType(options.LogSequenceType,
                Enum.GetNames(typeof(SampleLogFileComparator.LogSequence)), LogSequenceMessage);
            CheckOptionType(options.MatchPattern,
                Enum.GetNames(typeof(SampleLogFileComparator.MatchPattern)), MatchPatternMessage);

            return options;
        }

        /// <summary>
        /// プログラム引数のオプションをチェックする。
        /// </summary>
        /// <param name="option">プログラム引数に指定されたオプション</param>
        /// <param name="optionTypes">オプションリスト</param>
        private static void CheckOptionType(string option, string[] optionTypes, string logMessage)
        {
            if (option != null)
            {
                var isMatch = false;
                if (optionTypes.Any(x => x == option))
                {
                    isMatch = true;
                }
                if (!isMatch)
                {
                    Console.WriteLine($"Fail {logMessage}"
                                      + ": Please specify from the following...");
                    optionTypes.ToList().ForEach(x => Console.WriteLine($" - {x}"));
                    Environment.Exit(1);
                }
            }
            else
            {
                Console.WriteLine($"Argument is 'null' or 'empty' : {logMessage}");
                Environment.Exit(1);
            }
        }
    }
}
