﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace SampleLogFileCompare
{
    using Nintendo.ToolFoundation.CommandLine;

    internal sealed class CommandLineOption
    {
        internal string PatternFile { get; private set; } = string.Empty;
        internal string LogFile { get; private set; } = string.Empty;
        internal string LogSequenceType { get; private set; } = string.Empty;
        internal string MatchPattern { get; private set; } = string.Empty;
        internal bool IgnoreRunOnTargetLog { get; set; }

        internal void RegiserWith(DelegateBasedCommandLineParser parser)
        {
            parser.AddValueOption("PatternFile", x => this.PatternFile = x)
                .SetDescription("specify pattern file")
                .SetRequired();

            parser.AddValueOption("LogFile", x => this.LogFile = x)
                .SetDescription("specify log file")
                .SetRequired();

            parser.AddValueOption("LogSequenceType", x => this.LogSequenceType = x)
                .SetDescription("specify log sequence type")
                .SetRequired();

            parser.AddValueOption("MatchPattern", x => this.MatchPattern = x)
                .SetDescription("specify matching pattern")
                .SetRequired();

            parser.AddFlagOption("Header", () => this.IgnoreRunOnTargetLog = true)
                .SetDescription("if specified, ignore RunOnTarget log");
        }
    }
}
