﻿#
#  コンフィグデータ読み込み
#
function Make-PackageList( [Xml]$c )
{
    $namesList = @()

    $script:ContentsList = $c
    $plist = [array]($c.Configuration.ContentsList.Package)

    for( $i=0; $i -lt $plist.Length; $i++ )
    {
        $p = $plist[$i]
        $nlist = [array]($p.PName)

        #---- 要素最初のを加える
        $namesList += $nlist[0]
    }

    return $namesList
}


#----------------------------------------------------------------
# トップページのバージョン指定がいくつあるか
function Get-NumberOfTopVersion()
{
    return ([array]([xml]$script:ContentsList).Configuration.ContentsList.TopVersionList.VersionGroup).Length
}

#----------------------------------------------------------------
# トップページ の 指定バージョン情報取得
function Get-TopVersionInfo( $n )
{
    $plist = ([array]([xml]$script:ContentsList).Configuration.ContentsList.TopVersionList.VersionGroup)[$n]
    $VersionString = $plist.VersionString
    if ( $VersionString -eq $null )
    {
        $VersionString = ([array]$plist.Version)[0]
    }
    return [array]($plist.Version), $plist.Supplementation, $VersionString
}

#----------------------------------------------------------------
# TagInfo がいくつあるか
function Get-NumberOfTagInfo()
{
    return ([array]([xml]$script:ContentsList).Configuration.ContentsList.TagInfoList.TagInfo).Length
}
#----------------------------------------------------------------
# TagInfo の 指定インデクス取得
function Get-TagInfoName( $n )
{
    $plist = ([array]([xml]$script:ContentsList).Configuration.ContentsList.TagInfoList.TagInfo)[$n]
    $TagInfoNameString = $plist.TagInfoName
    return $TagInfoNameString
}

#----------------------------------------------------------------
# パッケージリストの数
function Get-PackageListNum()
{
    return ([array]([xml]$script:ContentsList).Configuration.ContentsList.PackageList).Length
}

#----------------------------------------------------------------
# 指定パッケージリストの共通情報取得
function Get-PackageListCommonInfo( $n )
{
    $plist = ([array]([xml]$script:ContentsList).Configuration.ContentsList.PackageList)[$n]
    $Subject = $plist.Common.Subject
    if ( $Subject -eq $null )
    {
        $Subject = $plist.Common.PackageName
    }
    return $plist.Common.PackageName, $Subject, $plist.Common.IdPrefix, [array]$plist.Common.PName
}

#----------------------------------------------------------------
# 指定パッケージリストのパッケージ数取得
function Get-PackageListPackageNum( $n )
{
    return ([array]([array]([xml]$script:ContentsList).Configuration.ContentsList.PackageList)[$n].Package).Length
}

#----------------------------------------------------------------
# 指定パッケージリストの指定パッケージの情報取得
function Get-PackageListPackageInfo( $n, $m )
{
    $plist = ([array]([array]([xml]$script:ContentsList).Configuration.ContentsList.PackageList)[$n].Package)[$m]
    return $plist.Supplementation, [array]$plist.Version, $plist.IdPrefix, $plist.Subject, $plist.VersionString
}
function Get-PackageListPackageNames( $n, $m )
{
    $plist = ([array]([array]([xml]$script:ContentsList).Configuration.ContentsList.PackageList)[$n].Package)[$m]
    return [array]$plist.PName
}
