﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace PackageCreator
{
    public static class PackageType
    {
        [Flags]
        public enum Type : byte
        {
            Public = 1,         // 0b001
            Private = 3,        // 0b011
            Confidential = 7,   // 0b111
        }

        public static Type Convert(string str)
        {
            Type? type = null;
            switch(str)
            {
                case "Public":
                    type = Type.Public;
                    break;
                case "Private":
                    type = Type.Private;
                    break;
                case "Confidential":
                    type = Type.Confidential;
                    break;
            }

            if(type == null)
            {
                throw new ArgumentException();
            }
            return type.Value;
        }
    }
}
