﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

using Phidgets;

namespace NxAgingHelper
{
    internal class PhidgetEdevController : ISdevController
    {
        private InterfaceKit m_InterfaceKit;

        public void Open(string hostname)
        {
            m_InterfaceKit = new InterfaceKit();

            try
            {
                m_InterfaceKit.open();
                m_InterfaceKit.waitForAttachment(1000);
            }
            catch (Exception e)
            {
                throw new Exception("Failed to connect to phidget.", e);
            }
        }

        public void Close()
        {
            m_InterfaceKit.close();
        }

        public void PressPowerButton(int holdTime)
        {
            Task.Run(async () =>
            {
                m_InterfaceKit.outputs[2] = true;
                await Task.Delay(holdTime);
                m_InterfaceKit.outputs[2] = false;
            });
        }

        public void ReleasePowerButtonForClose()
        {
            m_InterfaceKit.outputs[2] = false;
        }

        public void SwitchUsbPort(bool enable)
        {
            throw new NotImplementedException("Cannot switch USB port on EDEV with phidget.");
        }

        public void BatteryEmulation(int voltage, int percentage)
        {
            throw new NotImplementedException("Cannot Battery Emulation on EDEV with phidget.");
        }
    }
}
