﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NxAgingHelper
{
    public class AgingManagerPrivate
    {
        private readonly AgingManager m_AgingManager;

        private readonly PhidgetEdevController m_PhidgetEdevController;

        public bool UseMcci {
            get
            {
                return m_AgingManager.UseMcci;
            }
            set
            {
                m_AgingManager.UseMcci = value;
            }
        }

        public bool UseHdmi
        {
            get
            {
                return m_AgingManager.UseHdmi;
            }
            set
            {
                m_AgingManager.UseHdmi = value;
            }
        }

        public bool UsePowerUsb
        {
            get
            {
                return m_AgingManager.UsePowerUsb;
            }
            set
            {
                m_AgingManager.UsePowerUsb = value;
            }
        }

        public bool UseSdev
        {
            get
            {
                return m_AgingManager.UseSdev;
            }
            set
            {
                m_AgingManager.UseSdev = value;
            }
        }

        public bool UseBattery
        {
            get
            {
                return m_AgingManager.UseBattery;
            }
            set
            {
                m_AgingManager.UseBattery = value;
            }
        }

        public event AgingManager.ExceptionHandler ExceptionHandleEvent
        {
            add
            {
                m_AgingManager.ExceptionHandleEvent += value;
            }
            remove
            {
                m_AgingManager.ExceptionHandleEvent -= value;
            }
        }

        public AgingManagerPrivate()
        {
            m_AgingManager = new AgingManager();

            m_PhidgetEdevController = new PhidgetEdevController();
        }

        public void Start(ExecuteCommand command, string logFilePath, string sdevHostName, string mcciPortName, string hdmiTargetName, bool usePhidgetForSleep)
        {
            if (usePhidgetForSleep)
            {
                m_AgingManager.ControllerSet.Sdev = m_PhidgetEdevController;
            }

            m_AgingManager.Start(command, logFilePath, sdevHostName, mcciPortName, hdmiTargetName);
        }

        public void Stop()
        {
            m_AgingManager.Stop();
        }
    }
}
