﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

using System.IO;
using System.IO.Ports;

namespace NxAgingHelper
{
    public class EdevUartLogger
    {
        public event UartLogger.ExceptionHandler ExceptionHandleEvent;
        public event UartLogger.ReceiveHandler ReceiveHandleEvent;

        private CancellationTokenSource m_TokenSource;
        private SerialPort m_SerialPort;

        public void Start(string portName, string logFilePath)
        {
            m_SerialPort = new SerialPort(portName, 115200);
            m_SerialPort.ReadTimeout = 1000;
            m_SerialPort.Open();

            m_TokenSource = new CancellationTokenSource();

            Task.Run(() =>
            {
                var formatter = new UartLoggerFormatter();

                using (var writer = new StreamWriter(logFilePath, true))
                using (var reader = new StreamReader(m_SerialPort.BaseStream))
                {
                    while (true)
                    {
                        try
                        {
                            var buffer = new char[256];

                            var task = reader.ReadAsync(buffer, 0, buffer.Length);
                            task.Wait(m_TokenSource.Token);

                            var readSize = task.Result;
                            if (readSize > 0)
                            {
                                Array.Resize(ref buffer, readSize);
                                var text = formatter.Format(new string(buffer));

                                ReceiveHandleEvent?.Invoke(text);

                                writer.Write(text);
                                writer.Flush();
                            }

                            if (m_TokenSource.Token.IsCancellationRequested)
                            {
                                break;
                            }
                        }
                        catch (OperationCanceledException)
                        {
                            break;
                        }
                        catch (Exception e)
                        {
                            if (ExceptionHandleEvent != null)
                            {
                                ExceptionHandleEvent(new Exception("Error occurred in Uart logging.", e));
                                break;
                            }
                            else
                            {
                                throw;
                            }
                        }
                    }
                }

                m_SerialPort.Close();
                m_TokenSource.Dispose();
            });
        }

        public void Stop()
        {
            m_TokenSource.Cancel();
        }
    }
}
