﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Runtime.InteropServices;

using System.IO.Ports;

namespace NxAgingHelper
{
    internal class PowerUsbDllWrapper
    {
        private const string PowerUsbDllPath = "C:\\Program Files (x86)\\PowerUSB\\PwrUSBDll.dll";

        [DllImport(PowerUsbDllPath, CallingConvention = CallingConvention.Cdecl)]
        public static extern int InitPowerUSB(out int mode, StringBuilder firmwareVersion);

        [DllImport(PowerUsbDllPath, CallingConvention = CallingConvention.Cdecl)]
        public static extern int ClosePowerUSB();

        [DllImport(PowerUsbDllPath, CallingConvention = CallingConvention.Cdecl)]
        public static extern int SetPortPowerUSB(int port1_power, int port2_power, int port3_power);
    }

    public class PowerUsbController
    {
        private bool m_Port1;
        private bool m_Port2;
        private bool m_Port3;

        private int m_Model;
        private StringBuilder m_Firmware = new StringBuilder(128);

        public void Open()
        {
            m_Port1 = true;
            m_Port2 = true;
            m_Port3 = true;

            int ret = PowerUsbDllWrapper.InitPowerUSB(out m_Model, m_Firmware);
            if (ret <= 0)
            {
                throw new Exception("Failed to initialize Power USB.");
            }

            SetPortPowerUsb();
        }

        public void Close()
        {
            PowerUsbDllWrapper.ClosePowerUSB();
        }

        public void Update(int port, bool enable)
        {
            switch (port)
            {
                case 1:
                    m_Port1 = enable;
                    break;
                case 2:
                    m_Port2 = enable;
                    break;
                case 3:
                    m_Port3 = enable;
                    break;
                default:
                    return;
            }
            SetPortPowerUsb();
        }

        private void SetPortPowerUsb()
        {
            int ret = PowerUsbDllWrapper.SetPortPowerUSB(m_Port1 ? 1 : 0, m_Port2 ? 1 : 0, m_Port3 ? 1 : 0);
            if (ret < 0)
            {
                throw new Exception("Failed to control Power USB.");
            }
        }
    }
}
