﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO.Ports;

namespace NxAgingHelper
{
    public class McciController
    {
        private SerialPort m_Port;

        public void Open(string portName)
        {
            try
            {
                m_Port = new SerialPort(portName, 9600);
                m_Port.Open();
            }
            catch (Exception e)
            {
                throw new Exception(string.Format("Failed to connect to MCCI 3101 ({0}).", portName), e);
            }
        }

        public void Close()
        {
            m_Port.Close();
        }

        public void Connect()
        {
            m_Port.Write("port 1\r");
        }

        public void Disconnect()
        {
            m_Port.Write("port 0\r");
        }
    }
}
