﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Microsoft.VisualStudio.Shell.Interop;
using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.VcAccessors
{
    /// <summary>
    /// vcxproj である IVsHierarchy にアクセスします。アクセス中に本アクセッサ以外からの変更によってプロジェクトの状態が変化した場合の動作は未定義です。
    /// </summary>
    public class VcProjectAccessor
    {
        private Lazy<IList<VcProjectConfigurationAccessor>> _configurationAccessors;

        public VcProjectAccessor(IVsHierarchy h)
            : this(VcAccessorUtil.GetDTEProject(h).Object)  // Microsoft.VisualStudio.VCProject
        {
        }

        private VcProjectAccessor(dynamic vcProject)
        {
            this.InnerObject = vcProject;  // Microsoft.VisualStudio.VCProject
            this._configurationAccessors = new Lazy<IList<VcProjectConfigurationAccessor>>(
                () => ((IEnumerable)this.InnerObject.Configurations)
                    .Cast<dynamic>()
                    .Select(x => new VcProjectConfigurationAccessor(x)).ToList());
        }

        //public static VcProjectAccessor CreateFromVcProject(dynamic vcProject)
        //{
        //    return new VcProjectAccessor(vcProject);
        //}

        public string ProjectFilePath => this.InnerObject.ProjectFile;
        public IEnumerable<VcProjectConfigurationAccessor> Configurations => this._configurationAccessors.Value;
        internal dynamic InnerObject { get; }

        public VcProjectConfigurationAccessor GetConfigurationAccessor(ConfigurationPair configurationPair)
        {
            try
            {
                return _configurationAccessors.Value.First(x => x.ConfigurationPair == configurationPair);
            }
            catch (InvalidOperationException e)
            {
                throw new ArgumentException(
                    string.Format(Resources.InternalStrings.VcProjectAccessor_NoSuchConfigurationPair, configurationPair),
                    nameof(configurationPair),
                    e);
            }
        }
    }
}
