﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace Nintendo.NintendoSdkVsExtension.Views
{
    /// <summary>
    /// Finished に true が設定されたらダイアログを閉じる Behavior 的なもの。
    /// </summary>
    public class DialogCloser : Freezable
    {
        /// <summary>
        /// 本インスタンスの親コントロール。Parent が存在するウィンドウが、表示するダイアログの親ウィンドウとなる。
        /// </summary>
        public UIElement Parent
        {
            get { return (UIElement)GetValue(ParentProperty); }
            set { SetValue(ParentProperty, value); }
        }
        public static readonly DependencyProperty ParentProperty =
            DependencyProperty.Register(
                "Parent", typeof(UIElement), typeof(DialogCloser),
                new PropertyMetadata());

        /// <summary>
        /// 値が設定された場合にダイアログを閉じる。
        /// </summary>
        public bool? DialogResult
        {
            get { return (bool?)GetValue(DialogResultProperty); }
            set { SetValue(DialogResultProperty, value); }
        }
        public static readonly DependencyProperty DialogResultProperty =
            DependencyProperty.Register(
                "DialogResult", typeof(object), typeof(DialogCloser),
                new PropertyMetadata(null, OnDialogResultChanged));

        protected override Freezable CreateInstanceCore()
        {
            return new DialogPresenter();
        }

        private static void OnDialogResultChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
        {
            ((DialogCloser)d).OnDialogResultChanged(e);
        }

        private void OnDialogResultChanged(DependencyPropertyChangedEventArgs e)
        {
            if (object.Equals(e.OldValue, e.NewValue))
            {
                return;
            }

            bool? newValue = (bool?)e.NewValue;
            if (newValue.HasValue)
            {
                var parentWindow = ViewUtil.GetAncestorElementByType<Window>(this.Parent);
                parentWindow.DialogResult = newValue.Value;
            }
        }
    }
}
