﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Input;

namespace Nintendo.NintendoSdkVsExtension.ViewModels
{
    /// <summary>
    /// OK と Cancel コマンドを持つダイアログの VM。
    /// </summary>
    public class OkCancelDialogViewModelBase : DialogViewModelBase
    {
        private ICommand _okCommand;
        private ICommand _cancelCommand;

        /// <summary>
        /// (View 用) ダイアログのデータを適用して閉じる。
        /// </summary>
        public ICommand OkCommand => _okCommand ?? (_okCommand = new Common.RelayCommand(OnOk));

        /// <summary>
        /// (View 用) ダイアログのデータを適用せず閉じる。
        /// </summary>
        public ICommand CancelCommand => _cancelCommand ?? (_cancelCommand = new Common.RelayCommand(OnCancel));

        /// <summary>
        /// (親 VM 用) ダイアログのデータを適用すべきことであることを示すイベント
        /// </summary>
        public event EventHandler OkPressed;

        private void OnOk()
        {
            OkPressed?.Invoke(this, new EventArgs());
            this.DialogResult = true;
        }

        private void OnCancel()
        {
            this.DialogResult = false;
        }
    }
}
