﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.NintendoSdkVsExtension.Models
{
    /// <summary>
    /// SdkConfigurationSettingsStore の Bindable ラッパー + SdkInformation 取得
    /// </summary>
    public class SdkVcProjectConfiguration : Common.BindableBase
    {
        private SdkConfigurationSettingsStore _backingStore;

        public string Platform => _backingStore.ConfigurationPair.Platform;
        public string Configuration => _backingStore.ConfigurationPair.Configuration;

        public bool IsSdkEnabled
        {
            get { return _backingStore.IsSdkEnabled; }
            set { SetProperty(_backingStore, (x, v) => _backingStore.IsSdkEnabled = v, _backingStore.IsSdkEnabled, value); }
        }

        public SdkRoot SdkRoot
        {
            get { return this._backingStore.SdkRoot; }
            set
            {
                if (SetProperty(_backingStore, (x, v) => _backingStore.SdkRoot = v, _backingStore.SdkRoot, value))
                {
                    RaisePropretyChanged(nameof(this.SdkInformation));
                    RaisePropretyChanged(nameof(this.AvailableSpecs));
                }
            }
        }

        public string Spec
        {
            get { return _backingStore.Spec; }
            set { SetProperty(_backingStore, (x, v) => _backingStore.Spec = v, _backingStore.Spec, value); }
        }

        public SdkBuildType BuildType
        {
            get { return _backingStore.BuildType; }
            set { SetProperty(_backingStore, (x, v) => _backingStore.BuildType = v, _backingStore.BuildType, value); }
        }

        public SdkInformation SdkInformation =>
            Util.LoadSdkInformationOrDefault(this.SdkRoot.ToEvaluatedPath());

        public IEnumerable<string> AvailableSpecs =>
            SdkInformation?.Specs ?? SdkInformation.DefaultSpecs;

        public SdkVcProjectConfiguration(SdkConfigurationSettingsStore backingStore)
        {
            ThrowUtil.ThrowIfArgumentNull(backingStore, nameof(backingStore));

            this._backingStore = backingStore;
        }
    }
}
