﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using Nintendo.NintendoSdkVsExtension.Base;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;

namespace Nintendo.NintendoSdkVsExtension.Models
{
    /// <summary>
    /// SdkProjectSettingsStore の Bindable ラッパー + SdkInformation 取得
    /// </summary>
    public class SdkVcProject : Common.BindableBase
    {
        private string _projectFilePath = string.Empty;
        private SdkProjectSettingsStore _backingStore;
        private SdkVcProjectConfiguration[] _vcProjectConfigurations;

        public string ProjectFilePath
        {
            get { return _projectFilePath; }
            set { SetProperty(ref _projectFilePath, value); }
        }

        // TODO: これは削除して、外では SdkProjectSettingsStore を受け渡す
        public SdkProjectSettingsStore BackingStore => _backingStore;
        public IEnumerable<SdkVcProjectConfiguration> ProjectConfigurations => _vcProjectConfigurations;

        public SdkVcProject(string projectFilePath, SdkProjectSettingsStore backingStore)
        {
            ThrowUtil.ThrowIfArgumentNull(backingStore, nameof(backingStore));

            this._projectFilePath = projectFilePath;
            this._backingStore = backingStore;
            this._vcProjectConfigurations = this._backingStore.Configurations.Values.Select(x => new SdkVcProjectConfiguration(x)).ToArray();
        }
    }
}
